/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;

public class CampfireParticle
extends SpriteTexturedParticle {
    private CampfireParticle(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ, boolean longLivingEmber) {
        super(world, x, y, z);
        this.multiplyParticleScaleBy(3.0f);
        this.setSize(0.25f, 0.25f);
        this.maxAge = longLivingEmber ? this.rand.nextInt(50) + 280 : this.rand.nextInt(50) + 80;
        this.particleGravity = 3.0E-6f;
        this.motionX = motionX;
        this.motionY = motionY + (double)(this.rand.nextFloat() / 500.0f);
        this.motionZ = motionZ;
    }

    @Override
    public void tick() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.age++ < this.maxAge && !(this.particleAlpha <= 0.0f)) {
            this.motionX += (double)(this.rand.nextFloat() / 5000.0f * (float)(this.rand.nextBoolean() ? 1 : -1));
            this.motionZ += (double)(this.rand.nextFloat() / 5000.0f * (float)(this.rand.nextBoolean() ? 1 : -1));
            this.motionY -= (double)this.particleGravity;
            this.move(this.motionX, this.motionY, this.motionZ);
            if (this.age >= this.maxAge - 60 && this.particleAlpha > 0.01f) {
                this.particleAlpha -= 0.015f;
            }
        } else {
            this.setExpired();
        }
    }

    @Override
    public IParticleRenderType getRenderType() {
        return IParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class SignalSmokeFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public SignalSmokeFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CampfireParticle campfireparticle = new CampfireParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, true);
            campfireparticle.setAlphaF(0.95f);
            campfireparticle.selectSpriteRandomly(this.spriteSet);
            return campfireparticle;
        }
    }

    public static class CozySmokeFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public CozySmokeFactory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CampfireParticle campfireparticle = new CampfireParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, false);
            campfireparticle.setAlphaF(0.9f);
            campfireparticle.selectSpriteRandomly(this.spriteSet);
            return campfireparticle;
        }
    }
}

