/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.AlertScreen;
import net.minecraft.client.gui.screen.ConfirmBackupScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.EditWorldScreen;
import net.minecraft.client.gui.screen.ErrorScreen;
import net.minecraft.client.gui.screen.WorkingScreen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldSelectionList
extends ExtendedList<Entry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DateFormat field_214377_b = new SimpleDateFormat();
    private static final ResourceLocation field_214378_c = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation field_214379_d = new ResourceLocation("textures/gui/world_selection.png");
    private static final ITextComponent field_243462_r = new TranslationTextComponent("selectWorld.tooltip.fromNewerVersion1").mergeStyle(TextFormatting.RED);
    private static final ITextComponent field_243463_s = new TranslationTextComponent("selectWorld.tooltip.fromNewerVersion2").mergeStyle(TextFormatting.RED);
    private static final ITextComponent field_243464_t = new TranslationTextComponent("selectWorld.tooltip.snapshot1").mergeStyle(TextFormatting.GOLD);
    private static final ITextComponent field_243465_u = new TranslationTextComponent("selectWorld.tooltip.snapshot2").mergeStyle(TextFormatting.GOLD);
    private static final ITextComponent field_243466_v = new TranslationTextComponent("selectWorld.locked").mergeStyle(TextFormatting.RED);
    private final WorldSelectionScreen worldSelection;
    @Nullable
    private List<WorldSummary> field_212331_y;

    public WorldSelectionList(WorldSelectionScreen p_i49846_1_, Minecraft p_i49846_2_, int p_i49846_3_, int p_i49846_4_, int p_i49846_5_, int p_i49846_6_, int p_i49846_7_, Supplier<String> p_i49846_8_, @Nullable WorldSelectionList p_i49846_9_) {
        super(p_i49846_2_, p_i49846_3_, p_i49846_4_, p_i49846_5_, p_i49846_6_, p_i49846_7_);
        this.worldSelection = p_i49846_1_;
        if (p_i49846_9_ != null) {
            this.field_212331_y = p_i49846_9_.field_212331_y;
        }
        this.func_212330_a(p_i49846_8_, false);
    }

    public void func_212330_a(Supplier<String> p_212330_1_, boolean p_212330_2_) {
        this.clearEntries();
        SaveFormat saveformat = this.minecraft.getSaveLoader();
        if (this.field_212331_y == null || p_212330_2_) {
            try {
                this.field_212331_y = saveformat.getSaveList();
            }
            catch (AnvilConverterException anvilconverterexception) {
                LOGGER.error("Couldn't load level list", (Throwable)anvilconverterexception);
                this.minecraft.displayGuiScreen(new ErrorScreen(new TranslationTextComponent("selectWorld.unable_to_load"), new StringTextComponent(anvilconverterexception.getMessage())));
                return;
            }
            Collections.sort(this.field_212331_y);
        }
        if (this.field_212331_y.isEmpty()) {
            this.minecraft.displayGuiScreen(CreateWorldScreen.func_243425_a(null));
        } else {
            String s = p_212330_1_.get().toLowerCase(Locale.ROOT);
            for (WorldSummary worldsummary : this.field_212331_y) {
                if (!worldsummary.getDisplayName().toLowerCase(Locale.ROOT).contains(s) && !worldsummary.getFileName().toLowerCase(Locale.ROOT).contains(s)) continue;
                this.addEntry(new Entry(this, worldsummary));
            }
        }
    }

    @Override
    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 20;
    }

    @Override
    public int getRowWidth() {
        return super.getRowWidth() + 50;
    }

    @Override
    protected boolean isFocused() {
        return this.worldSelection.getListener() == this;
    }

    @Override
    public void setSelected(@Nullable Entry entry) {
        super.setSelected(entry);
        if (entry != null) {
            WorldSummary worldsummary = entry.worldSelector;
            NarratorChatListener.INSTANCE.say(new TranslationTextComponent("narrator.select", new TranslationTextComponent("narrator.select.world", worldsummary.getDisplayName(), new Date(worldsummary.getLastTimePlayed()), worldsummary.isHardcoreModeEnabled() ? new TranslationTextComponent("gameMode.hardcore") : new TranslationTextComponent("gameMode." + worldsummary.getEnumGameType().getName()), worldsummary.getCheatsEnabled() ? new TranslationTextComponent("selectWorld.cheats") : StringTextComponent.EMPTY, worldsummary.getVersionName())).getString());
        }
        this.worldSelection.setActive(entry != null && !entry.worldSelector.isLocked());
    }

    @Override
    protected void moveSelection(AbstractList.Ordering p_241219_1_) {
        this.func_241572_a_(p_241219_1_, p_241652_0_ -> !((Entry)p_241652_0_).worldSelector.isLocked());
    }

    public Optional<Entry> func_214376_a() {
        return Optional.ofNullable(this.getSelected());
    }

    public WorldSelectionScreen getGuiWorldSelection() {
        return this.worldSelection;
    }

    public final class Entry
    extends ExtendedList.AbstractListEntry<Entry>
    implements AutoCloseable {
        private final Minecraft minecraft;
        private final WorldSelectionScreen field_214450_c;
        private final WorldSummary worldSelector;
        private final ResourceLocation field_214452_e;
        private File field_214453_f;
        @Nullable
        private final DynamicTexture field_214454_g;
        private long field_214455_h;

        public Entry(WorldSelectionList p_i242066_2_, WorldSummary p_i242066_3_) {
            this.field_214450_c = p_i242066_2_.getGuiWorldSelection();
            this.worldSelector = p_i242066_3_;
            this.minecraft = Minecraft.getInstance();
            String s = p_i242066_3_.getFileName();
            this.field_214452_e = new ResourceLocation("minecraft", "worlds/" + Util.func_244361_a(s, ResourceLocation::validatePathChar) + "/" + Hashing.sha1().hashUnencodedChars(s) + "/icon");
            this.field_214453_f = p_i242066_3_.getIconFile();
            if (!this.field_214453_f.isFile()) {
                this.field_214453_f = null;
            }
            this.field_214454_g = this.func_214446_f();
        }

        @Override
        public void render(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            String s = this.worldSelector.getDisplayName();
            String s1 = this.worldSelector.getFileName() + " (" + field_214377_b.format(new Date(this.worldSelector.getLastTimePlayed())) + ")";
            if (StringUtils.isEmpty(s)) {
                s = I18n.format("selectWorld.world", new Object[0]) + " " + (p_230432_2_ + 1);
            }
            ITextComponent itextcomponent = this.worldSelector.getDescription();
            this.minecraft.fontRenderer.drawString(p_230432_1_, s, p_230432_4_ + 32 + 3, p_230432_3_ + 1, 0xFFFFFF);
            this.minecraft.fontRenderer.drawString(p_230432_1_, s1, p_230432_4_ + 32 + 3, p_230432_3_ + 9 + 3, 0x808080);
            this.minecraft.fontRenderer.func_243248_b(p_230432_1_, itextcomponent, p_230432_4_ + 32 + 3, p_230432_3_ + 9 + 9 + 3, 0x808080);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.minecraft.getTextureManager().bindTexture(this.field_214454_g != null ? this.field_214452_e : field_214378_c);
            RenderSystem.enableBlend();
            AbstractGui.blit(p_230432_1_, p_230432_4_, p_230432_3_, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
            if (this.minecraft.gameSettings.touchscreen || p_230432_9_) {
                int j;
                this.minecraft.getTextureManager().bindTexture(field_214379_d);
                AbstractGui.fill(p_230432_1_, p_230432_4_, p_230432_3_, p_230432_4_ + 32, p_230432_3_ + 32, -1601138544);
                RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                int i = p_230432_7_ - p_230432_4_;
                boolean flag = i < 32;
                int n = j = flag ? 32 : 0;
                if (this.worldSelector.isLocked()) {
                    AbstractGui.blit(p_230432_1_, p_230432_4_, p_230432_3_, 96.0f, j, 32, 32, 256, 256);
                    if (flag) {
                        this.field_214450_c.func_239026_b_(this.minecraft.fontRenderer.trimStringToWidth(field_243466_v, 175));
                    }
                } else if (this.worldSelector.markVersionInList()) {
                    AbstractGui.blit(p_230432_1_, p_230432_4_, p_230432_3_, 32.0f, j, 32, 32, 256, 256);
                    if (this.worldSelector.askToOpenWorld()) {
                        AbstractGui.blit(p_230432_1_, p_230432_4_, p_230432_3_, 96.0f, j, 32, 32, 256, 256);
                        if (flag) {
                            this.field_214450_c.func_239026_b_(ImmutableList.of(field_243462_r.func_241878_f(), field_243463_s.func_241878_f()));
                        }
                    } else if (!SharedConstants.getVersion().isStable()) {
                        AbstractGui.blit(p_230432_1_, p_230432_4_, p_230432_3_, 64.0f, j, 32, 32, 256, 256);
                        if (flag) {
                            this.field_214450_c.func_239026_b_(ImmutableList.of(field_243464_t.func_241878_f(), field_243465_u.func_241878_f()));
                        }
                    }
                } else {
                    AbstractGui.blit(p_230432_1_, p_230432_4_, p_230432_3_, 0.0f, j, 32, 32, 256, 256);
                }
            }
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.worldSelector.isLocked()) {
                return true;
            }
            WorldSelectionList.this.setSelected(this);
            this.field_214450_c.setActive(WorldSelectionList.this.func_214376_a().isPresent());
            if (mouseX - (double)WorldSelectionList.this.getRowLeft() <= 32.0) {
                this.loadWorld();
                return true;
            }
            if (Util.milliTime() - this.field_214455_h < 250L) {
                this.loadWorld();
                return true;
            }
            this.field_214455_h = Util.milliTime();
            return false;
        }

        public void loadWorld() {
            if (!this.worldSelector.isLocked()) {
                if (this.worldSelector.askToCreateBackup()) {
                    TranslationTextComponent itextcomponent = new TranslationTextComponent("selectWorld.backupQuestion");
                    TranslationTextComponent itextcomponent1 = new TranslationTextComponent("selectWorld.backupWarning", this.worldSelector.getVersionName(), SharedConstants.getVersion().getName());
                    this.minecraft.displayGuiScreen(new ConfirmBackupScreen(this.field_214450_c, (p_214436_1_, p_214436_2_) -> {
                        if (p_214436_1_) {
                            String s = this.worldSelector.getFileName();
                            try (SaveFormat.LevelSave saveformat$levelsave = this.minecraft.getSaveLoader().getLevelSave(s);){
                                EditWorldScreen.func_239019_a_(saveformat$levelsave);
                            }
                            catch (IOException ioexception) {
                                SystemToast.func_238535_a_(this.minecraft, s);
                                LOGGER.error("Failed to backup level {}", (Object)s, (Object)ioexception);
                            }
                        }
                        this.loadWorldImpl();
                    }, itextcomponent, itextcomponent1, false));
                } else if (this.worldSelector.askToOpenWorld()) {
                    this.minecraft.displayGuiScreen(new ConfirmScreen(p_214434_1_ -> {
                        if (p_214434_1_) {
                            try {
                                this.loadWorldImpl();
                            }
                            catch (Exception exception) {
                                LOGGER.error("Failure to open 'future world'", (Throwable)exception);
                                this.minecraft.displayGuiScreen(new AlertScreen(() -> this.minecraft.displayGuiScreen(this.field_214450_c), new TranslationTextComponent("selectWorld.futureworld.error.title"), new TranslationTextComponent("selectWorld.futureworld.error.text")));
                            }
                        } else {
                            this.minecraft.displayGuiScreen(this.field_214450_c);
                        }
                    }, new TranslationTextComponent("selectWorld.versionQuestion"), new TranslationTextComponent("selectWorld.versionWarning", this.worldSelector.getVersionName(), new TranslationTextComponent("selectWorld.versionJoinButton"), DialogTexts.GUI_CANCEL)));
                } else {
                    this.loadWorldImpl();
                }
            }
        }

        public void func_214442_b() {
            this.minecraft.displayGuiScreen(new ConfirmScreen(p_214440_1_ -> {
                if (p_214440_1_) {
                    this.minecraft.displayGuiScreen(new WorkingScreen());
                    SaveFormat saveformat = this.minecraft.getSaveLoader();
                    String s = this.worldSelector.getFileName();
                    try (SaveFormat.LevelSave saveformat$levelsave = saveformat.getLevelSave(s);){
                        saveformat$levelsave.deleteSave();
                    }
                    catch (IOException ioexception) {
                        SystemToast.func_238538_b_(this.minecraft, s);
                        LOGGER.error("Failed to delete world {}", (Object)s, (Object)ioexception);
                    }
                    WorldSelectionList.this.func_212330_a(() -> this.field_214450_c.searchField.getText(), true);
                }
                this.minecraft.displayGuiScreen(this.field_214450_c);
            }, new TranslationTextComponent("selectWorld.deleteQuestion"), new TranslationTextComponent("selectWorld.deleteWarning", this.worldSelector.getDisplayName()), new TranslationTextComponent("selectWorld.deleteButton"), DialogTexts.GUI_CANCEL));
        }

        public void func_214444_c() {
            String s = this.worldSelector.getFileName();
            try {
                SaveFormat.LevelSave saveformat$levelsave = this.minecraft.getSaveLoader().getLevelSave(s);
                this.minecraft.displayGuiScreen(new EditWorldScreen(p_239096_3_ -> {
                    try {
                        saveformat$levelsave.close();
                    }
                    catch (IOException ioexception1) {
                        LOGGER.error("Failed to unlock level {}", (Object)s, (Object)ioexception1);
                    }
                    if (p_239096_3_) {
                        WorldSelectionList.this.func_212330_a(() -> this.field_214450_c.searchField.getText(), true);
                    }
                    this.minecraft.displayGuiScreen(this.field_214450_c);
                }, saveformat$levelsave));
            }
            catch (IOException ioexception) {
                SystemToast.func_238535_a_(this.minecraft, s);
                LOGGER.error("Failed to access level {}", (Object)s, (Object)ioexception);
                WorldSelectionList.this.func_212330_a(() -> this.field_214450_c.searchField.getText(), true);
            }
        }

        public void func_214445_d() {
            this.showLoadWorldScreen();
            DynamicRegistries.Impl dynamicregistries$impl = DynamicRegistries.getImpl();
            try (SaveFormat.LevelSave saveformat$levelsave = this.minecraft.getSaveLoader().getLevelSave(this.worldSelector.getFileName());
                 Minecraft.PackManager minecraft$packmanager = this.minecraft.reloadDatapacks(dynamicregistries$impl, Minecraft::loadDataPackCodec, Minecraft::loadWorld, false, saveformat$levelsave);){
                WorldSettings worldsettings = minecraft$packmanager.getServerConfiguration().getWorldSettings();
                DatapackCodec datapackcodec = worldsettings.getDatapackCodec();
                DimensionGeneratorSettings dimensionGeneratorSettings = minecraft$packmanager.getServerConfiguration().getDimensionGeneratorSettings();
                Path path = CreateWorldScreen.func_238943_a_(saveformat$levelsave.resolveFilePath(FolderName.DATAPACKS), this.minecraft);
                if (dimensionGeneratorSettings.func_236229_j_()) {
                    this.minecraft.displayGuiScreen(new ConfirmScreen(p_239095_6_ -> this.minecraft.displayGuiScreen(p_239095_6_ ? new CreateWorldScreen(this.field_214450_c, worldsettings, dimensionGeneratorSettings, path, datapackcodec, dynamicregistries$impl) : this.field_214450_c), new TranslationTextComponent("selectWorld.recreate.customized.title"), new TranslationTextComponent("selectWorld.recreate.customized.text"), DialogTexts.GUI_PROCEED, DialogTexts.GUI_CANCEL));
                } else {
                    this.minecraft.displayGuiScreen(new CreateWorldScreen(this.field_214450_c, worldsettings, dimensionGeneratorSettings, path, datapackcodec, dynamicregistries$impl));
                }
            }
            catch (Exception exception) {
                LOGGER.error("Unable to recreate world", (Throwable)exception);
                this.minecraft.displayGuiScreen(new AlertScreen(() -> this.minecraft.displayGuiScreen(this.field_214450_c), new TranslationTextComponent("selectWorld.recreate.error.title"), new TranslationTextComponent("selectWorld.recreate.error.text")));
            }
        }

        private void loadWorldImpl() {
            this.minecraft.getSoundHandler().play(SimpleSound.master(SoundEvents.UI_BUTTON_CLICK, 1.0f));
            if (this.minecraft.getSaveLoader().canLoadWorld(this.worldSelector.getFileName())) {
                this.showLoadWorldScreen();
                this.minecraft.loadWorld(this.worldSelector.getFileName());
            }
        }

        private void showLoadWorldScreen() {
            this.minecraft.forcedScreenTick(new DirtMessageScreen(new TranslationTextComponent("selectWorld.data_read")));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        private DynamicTexture func_214446_f() {
            boolean flag;
            boolean bl = flag = this.field_214453_f != null && this.field_214453_f.isFile();
            if (!flag) {
                this.minecraft.getTextureManager().deleteTexture(this.field_214452_e);
                return null;
            }
            try (FileInputStream inputstream = new FileInputStream(this.field_214453_f);){
                NativeImage nativeimage = NativeImage.read(inputstream);
                Validate.validState(nativeimage.getWidth() == 64, "Must be 64 pixels wide", new Object[0]);
                Validate.validState(nativeimage.getHeight() == 64, "Must be 64 pixels high", new Object[0]);
                DynamicTexture dynamictexture = new DynamicTexture(nativeimage);
                this.minecraft.getTextureManager().loadTexture(this.field_214452_e, dynamictexture);
                DynamicTexture dynamicTexture = dynamictexture;
                return dynamicTexture;
            }
            catch (Throwable throwable6) {
                LOGGER.error("Invalid icon for world {}", (Object)this.worldSelector.getFileName(), (Object)throwable6);
                this.field_214453_f = null;
                return null;
            }
        }

        @Override
        public void close() {
            if (this.field_214454_g != null) {
                this.field_214454_g.close();
            }
        }
    }
}

