/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import net.minecraft.client.audio.TickableSound;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public class EntityTickableSound
extends TickableSound {
    private final Entity entity;

    public EntityTickableSound(SoundEvent sound, SoundCategory category, Entity entity) {
        this(sound, category, 1.0f, 1.0f, entity);
    }

    public EntityTickableSound(SoundEvent sound, SoundCategory category, float volume, float pitch, Entity entity) {
        super(sound, category);
        this.volume = volume;
        this.pitch = pitch;
        this.entity = entity;
        this.x = (float)this.entity.getPosX();
        this.y = (float)this.entity.getPosY();
        this.z = (float)this.entity.getPosZ();
    }

    @Override
    public boolean shouldPlaySound() {
        return !this.entity.isSilent();
    }

    @Override
    public void tick() {
        if (this.entity.removed) {
            this.finishPlaying();
        } else {
            this.x = (float)this.entity.getPosX();
            this.y = (float)this.entity.getPosY();
            this.z = (float)this.entity.getPosZ();
        }
    }
}

