/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minerl.multiagent.RandomHelper;
import com.minerl.multiagent.recorder.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.KeyboardListener;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.TranslationTextComponent;

public class ReplaySender {
    private static ReplaySender instance = new ReplaySender();
    private List<JsonObject> actions;
    private boolean firstTick = false;
    private int serverStartTick;
    private JsonObject lastAction = null;
    private Mode mode = Mode.OFF;

    public static ReplaySender getInstance() {
        return instance;
    }

    public synchronized void sendFromFile(String recordingFile, int serverStartTick) {
        if (this.mode != Mode.OFF) {
            throw new RuntimeException("ReplaySender is already sending the replay, need to stop it first");
        }
        Gson gson = new Gson();
        try {
            this.serverStartTick = serverStartTick;
            this.actions = Files.readAllLines(new File(recordingFile).toPath(), Charset.defaultCharset()).stream().map(s -> gson.fromJson((String)s, JsonObject.class)).filter(j -> j.get("serverTick").getAsInt() >= serverStartTick - 1).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Minecraft mc = Minecraft.getInstance();
        mc.mouseHelper.setHumanInput(false);
        this.mode = Mode.REPLAY_FILE;
        this.firstTick = true;
    }

    public synchronized void sendFromEnv() {
        if (this.mode != Mode.OFF) {
            throw new RuntimeException("ReplaySender is already sending the replay, need to stop it first");
        }
        Minecraft mc = Minecraft.getInstance();
        mc.mouseHelper.setHumanInput(false);
        this.actions = new LinkedList<JsonObject>();
        this.mode = Mode.EXEC_CMD;
        this.firstTick = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (this.mode == Mode.OFF) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (this.mode == Mode.REPLAY_FILE && this.actions.size() == 0) {
            this.stop();
        }
        if (!mc.mouseHelper.getHumanInput()) {
            mc.getProfiler().startSection("waitForAction");
            try {
                ReplaySender replaySender = this;
                synchronized (replaySender) {
                    while (this.mode == Mode.EXEC_CMD && this.actions.size() == 0) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            mc.getProfiler().endSection();
            if (this.firstTick) {
                this.onFirstTick();
                this.firstTick = false;
            }
            mc.getProfiler().startSection("execAction");
            if (this.actions.size() > 0) {
                JsonObject action = this.actions.remove(0);
                this.execAction(action);
            }
            mc.getProfiler().endSection();
        } else {
            this.actions.clear();
        }
    }

    private void onFirstTick() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(JsonObject e) {
        this.actions.add(e);
        ReplaySender replaySender = this;
        synchronized (replaySender) {
            this.notifyAll();
        }
    }

    public void addAction(MouseHelper.State mouseState, KeyboardListener.State keyboardState) {
        Gson gson = new Gson();
        JsonObject jo = new JsonObject();
        jo.add("mouse", gson.toJsonTree(mouseState));
        jo.add("keyboard", gson.toJsonTree(keyboardState));
        jo.addProperty("isGuiOpen", false);
        this.addAction(jo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.mode != Mode.OFF) {
            System.out.println("*** Stopping the replay, returning control to the inputs");
            Minecraft mc = Minecraft.getInstance();
            mc.execute(() -> {
                mc.mouseHelper.setHumanInput(true);
                mc.world.sendQuittingDisconnectingPacket();
                mc.unloadWorld(new DirtMessageScreen(new TranslationTextComponent("menu.savingLevel")));
                mc.displayGuiScreen(new MainMenuScreen());
            });
            this.mode = Mode.OFF;
            ReplaySender replaySender = this;
            synchronized (replaySender) {
                this.notifyAll();
            }
        }
    }

    private static KeyboardListener.State getKeyboardState(JsonObject action) {
        Gson gson = new Gson();
        return gson.fromJson((JsonElement)action.getAsJsonObject("keyboard"), KeyboardListener.State.class);
    }

    private static MouseHelper.State getMouseState(JsonObject action) {
        Gson gson = new Gson();
        return gson.fromJson((JsonElement)action.getAsJsonObject("mouse"), MouseHelper.State.class);
    }

    private void execAction(JsonObject action) {
        Minecraft mc = Minecraft.getInstance();
        MouseHelper.State mouseState = ReplaySender.getMouseState(action);
        KeyboardListener.State keyboardState = ReplaySender.getKeyboardState(action);
        int mods = this.getModifiers(keyboardState.keys);
        if (action.get("serverTick") == null || action.get("serverTick").getAsInt() >= this.serverStartTick) {
            if (this.firstTick) {
                this.onFirstTick();
                this.firstTick = false;
            }
            if (this.mode == Mode.REPLAY_FILE) {
                this.checkPlayerPosition();
                this.checkPlayerInventory();
            }
            this.execKeyboard(keyboardState);
            this.execMouseMove(mouseState);
            this.execMouseButtons(mouseState.buttons, mods);
            this.execMouseScroll(mouseState.dwheel);
        }
        this.lastAction = action;
    }

    private static void setPlayerPosition(JsonObject action) {
        if (action == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        mc.player.rotationYaw = action.get("yaw").getAsFloat();
        mc.player.rotationPitch = action.get("pitch").getAsFloat();
        mc.player.setPosition(action.get("xpos").getAsDouble(), action.get("ypos").getAsDouble(), action.get("zpos").getAsDouble());
    }

    private void checkPlayerPosition() {
        JsonObject action = this.lastAction;
        if (action == null) {
            return;
        }
        double maxCoordDiff = 1.0;
        double maxAngleDiff = 1.0;
        Minecraft mc = Minecraft.getInstance();
        if (Math.abs(mc.player.getPosX() - this.lastAction.get("xpos").getAsDouble()) > maxCoordDiff || Math.abs(mc.player.getPosY() - this.lastAction.get("ypos").getAsDouble()) > maxCoordDiff || Math.abs(mc.player.getPosZ() - this.lastAction.get("zpos").getAsDouble()) > maxCoordDiff || Math.abs((double)mc.player.rotationYaw - this.lastAction.get("yaw").getAsDouble()) > maxAngleDiff || Math.abs((double)mc.player.rotationPitch - this.lastAction.get("pitch").getAsDouble()) > maxAngleDiff) {
            System.out.println("position or angle have drifted, should stop the replay");
        }
    }

    private void checkPlayerInventory() {
    }

    private int getModifiers(Set<String> keys) {
        int retval = 0;
        if (keys.contains("key.keyboard.left.shift") || keys.contains("key.keyboard.right.shift")) {
            retval |= 1;
        }
        return retval;
    }

    private double clip(double v, double lower, double upper) {
        return Math.min(Math.max(v, lower), upper);
    }

    private void execMouseMove(MouseHelper.State mouseState) {
        Minecraft mc = Minecraft.getInstance();
        MouseHelper mh = mc.mouseHelper;
        MainWindow mw = mc.getMainWindow();
        if (mouseState.dx != 0.0 || mouseState.dy != 0.0) {
            double scaleFactor = mh.getScaleFactor();
            double newMouseX = mh.getMouseX() + mouseState.dx * scaleFactor;
            double newMouseY = mh.getMouseY() + mouseState.dy * scaleFactor;
            if (mc.currentScreen != null) {
                newMouseX = this.clip(newMouseX, 0.0, mw.getWidth());
                newMouseY = this.clip(newMouseY, 0.0, mw.getHeight());
            }
            mh.cursorPosCallbackImpl(newMouseX, newMouseY);
        }
    }

    private void execMouseButtons(Set<Integer> buttons, int mods) {
        int button;
        Minecraft mc = Minecraft.getInstance();
        HashSet<Integer> pressedButtons = new HashSet<Integer>();
        HashSet<Integer> releasedButtons = new HashSet<Integer>();
        pressedButtons.addAll(buttons);
        if (this.lastAction != null) {
            pressedButtons.removeAll(ReplaySender.getMouseState((JsonObject)this.lastAction).buttons);
            releasedButtons.addAll(ReplaySender.getMouseState((JsonObject)this.lastAction).buttons);
            releasedButtons.removeAll(buttons);
        }
        Iterator iterator = pressedButtons.iterator();
        while (iterator.hasNext()) {
            button = (Integer)iterator.next();
            mc.mouseHelper.mouseButtonCallbackImpl(mc.getMainWindow().getHandle(), button, 1, 0);
        }
        iterator = releasedButtons.iterator();
        while (iterator.hasNext()) {
            button = (Integer)iterator.next();
            mc.mouseHelper.mouseButtonCallbackImpl(mc.getMainWindow().getHandle(), button, 0, 0);
        }
        mc.mouseHelper.getState();
    }

    private void execKeyboard(KeyboardListener.State state) {
        InputMappings.Input input;
        Minecraft mc = Minecraft.getInstance();
        HashSet<String> newlyHitKeys = new HashSet<String>();
        HashSet<String> releasedKeys = new HashSet<String>();
        int mods = 0;
        newlyHitKeys.addAll(state.keys);
        if (this.lastAction != null) {
            newlyHitKeys.removeAll(ReplaySender.getKeyboardState((JsonObject)this.lastAction).keys);
            releasedKeys.addAll(ReplaySender.getKeyboardState((JsonObject)this.lastAction).keys);
            releasedKeys.removeAll(state.keys);
        }
        for (String key : newlyHitKeys) {
            input = InputMappings.getInputByName(key);
            if (this.lastAction != null && mc.currentScreen == null && key.equals("key.keyboard.escape") && mc.gameSettings.envPort != 0) continue;
            mc.keyboardListener.onKeyEventImpl(input.getKeyCode(), 0, 1, mods);
        }
        for (String key : releasedKeys) {
            input = InputMappings.getInputByName(key);
            mc.keyboardListener.onKeyEventImpl(input.getKeyCode(), 0, 0, mods);
        }
        Object object = state.chars.toCharArray();
        int n = ((Object)object).length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf((char)object[i]);
            mc.keyboardListener.onCharEventImpl(c.charValue(), mods);
        }
        mc.keyboardListener.getState();
    }

    private void execMouseScroll(double dwheel) {
        if (dwheel != 0.0) {
            Minecraft mc = Minecraft.getInstance();
            mc.mouseHelper.scrollCallbackImpl(mc.getMainWindow().getHandle(), 0.0, dwheel);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void loadWorldFromZip(String zipFile) {
        Minecraft mc = Minecraft.getInstance();
        List<String> zipEntries = ZipUtil.listZip(zipFile);
        String tmpDir = System.getProperty("java.io.tmpdir");
        Path saveBasePath = Paths.get(tmpDir, RandomHelper.getRandomHexString());
        System.out.println("Unzipping " + zipFile + " -> " + saveBasePath);
        ZipUtil.unzip(zipFile, saveBasePath.toString());
        String saveName = zipEntries.get(0).split("/")[2];
        mc.loadWorld(saveBasePath.resolve("saves"), saveName);
    }

    public void loadWorldAndReplay(String prefix) {
        this.loadWorldFromZip(prefix + ".zip");
        this.sendFromFile(prefix + ".jsonl", 0);
    }

    public static enum Mode {
        REPLAY_FILE,
        OFF,
        EXEC_CMD;

    }
}

