/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.util.MouseSmoother;
import net.minecraft.client.util.NativeUtil;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.glfw.GLFWDropCallback;

public class MouseHelper {
    private final Minecraft minecraft;
    private boolean leftDown;
    private boolean middleDown;
    private boolean rightDown;
    private double mouseX;
    private double mouseY;
    private int simulatedRightClicks;
    private int activeButton = -1;
    private boolean ignoreFirstMove = true;
    private int touchScreenCounter;
    private double eventTime;
    private final MouseSmoother xSmoother = new MouseSmoother();
    private final MouseSmoother ySmoother = new MouseSmoother();
    private double xVelocity;
    private double yVelocity;
    private double accumulatedScrollDelta;
    private double lastLookTime = Double.MIN_VALUE;
    private boolean mouseGrabbed;
    private double dx = 0.0;
    private double dy = 0.0;
    private double accumDwheel = 0.0;
    private boolean humanInput = true;
    private Set<Integer> buttonsPressed = new HashSet<Integer>();
    private Set<Integer> accumButtonsPressed = new HashSet<Integer>();
    private Set<Integer> buttonsNewlyPressed = new HashSet<Integer>();

    public MouseHelper(Minecraft minecraftIn) {
        this.minecraft = minecraftIn;
    }

    void mouseButtonCallback(long handle, int button, int action, int mods) {
        if (handle == this.minecraft.getMainWindow().getHandle() && this.humanInput) {
            this.mouseButtonCallbackImpl(handle, button, action, mods);
        }
        if (action == 1) {
            this.buttonsPressed.add(button);
            this.accumButtonsPressed.add(button);
            this.buttonsNewlyPressed.add(button);
        } else if (action == 0) {
            this.buttonsPressed.remove(button);
        } else {
            throw new RuntimeException("Unknown action! " + action);
        }
    }

    void mouseButtonCallbackImpl(long handle, int button, int action, int mods) {
        boolean flag;
        boolean bl = flag = action == 1;
        if (Minecraft.IS_RUNNING_ON_MAC && button == 0) {
            if (flag) {
                if ((mods & 2) == 2) {
                    button = 1;
                    ++this.simulatedRightClicks;
                }
            } else if (this.simulatedRightClicks > 0) {
                button = 1;
                --this.simulatedRightClicks;
            }
        }
        int i = button;
        if (flag) {
            if (this.minecraft.gameSettings.touchscreen && this.touchScreenCounter++ > 0) {
                return;
            }
            this.activeButton = i;
            this.eventTime = NativeUtil.getTime();
        } else if (this.activeButton != -1) {
            if (this.minecraft.gameSettings.touchscreen && --this.touchScreenCounter > 0) {
                return;
            }
            this.activeButton = -1;
        }
        boolean[] aboolean = new boolean[]{false};
        if (this.minecraft.loadingGui == null) {
            if (this.minecraft.currentScreen == null) {
                if (!this.mouseGrabbed && flag) {
                    this.grabMouse();
                }
            } else {
                double d0 = this.mouseX * (double)this.minecraft.getMainWindow().getScaledWidth() / (double)this.minecraft.getMainWindow().getWidth();
                double d1 = this.mouseY * (double)this.minecraft.getMainWindow().getScaledHeight() / (double)this.minecraft.getMainWindow().getHeight();
                if (flag) {
                    Screen.wrapScreenError(() -> {
                        aboolean[0] = this.minecraft.currentScreen.mouseClicked(d0, d1, i);
                    }, "mouseClicked event handler", this.minecraft.currentScreen.getClass().getCanonicalName());
                } else {
                    Screen.wrapScreenError(() -> {
                        aboolean[0] = this.minecraft.currentScreen.mouseReleased(d0, d1, i);
                    }, "mouseReleased event handler", this.minecraft.currentScreen.getClass().getCanonicalName());
                }
            }
        }
        if (!aboolean[0] && (this.minecraft.currentScreen == null || this.minecraft.currentScreen.passEvents) && this.minecraft.loadingGui == null) {
            if (i == 0) {
                this.leftDown = flag;
            } else if (i == 2) {
                this.middleDown = flag;
            } else if (i == 1) {
                this.rightDown = flag;
            }
            KeyBinding.setKeyBindState(InputMappings.Type.MOUSE.getOrMakeInput(i), flag);
            if (flag) {
                if (this.minecraft.player.isSpectator() && i == 2) {
                    this.minecraft.ingameGUI.getSpectatorGui().onMiddleClick();
                } else {
                    KeyBinding.onTick(InputMappings.Type.MOUSE.getOrMakeInput(i));
                }
            }
        }
    }

    void scrollCallback(long handle, double xoffset, double yoffset) {
        if (handle == this.minecraft.getMainWindow().getHandle() && this.humanInput) {
            this.scrollCallbackImpl(handle, xoffset, yoffset);
        }
        this.accumDwheel += yoffset;
    }

    void scrollCallbackImpl(long handle, double xoffset, double yoffset) {
        double d0 = (this.minecraft.gameSettings.discreteMouseScroll ? Math.signum(yoffset) : yoffset) * this.minecraft.gameSettings.mouseWheelSensitivity;
        if (this.minecraft.loadingGui == null) {
            if (this.minecraft.currentScreen != null) {
                double d1 = this.mouseX * (double)this.minecraft.getMainWindow().getScaledWidth() / (double)this.minecraft.getMainWindow().getWidth();
                double d2 = this.mouseY * (double)this.minecraft.getMainWindow().getScaledHeight() / (double)this.minecraft.getMainWindow().getHeight();
                this.minecraft.currentScreen.mouseScrolled(d1, d2, d0);
            } else if (this.minecraft.player != null) {
                if (this.accumulatedScrollDelta != 0.0 && Math.signum(d0) != Math.signum(this.accumulatedScrollDelta)) {
                    this.accumulatedScrollDelta = 0.0;
                }
                this.accumulatedScrollDelta += d0;
                float f1 = (int)this.accumulatedScrollDelta;
                if (f1 == 0.0f) {
                    return;
                }
                this.accumulatedScrollDelta -= (double)f1;
                if (this.minecraft.player.isSpectator()) {
                    if (this.minecraft.ingameGUI.getSpectatorGui().isMenuActive()) {
                        this.minecraft.ingameGUI.getSpectatorGui().onMouseScroll(-f1);
                    } else {
                        float f = MathHelper.clamp(this.minecraft.player.abilities.getFlySpeed() + f1 * 0.005f, 0.0f, 0.2f);
                        this.minecraft.player.abilities.setFlySpeed(f);
                    }
                } else {
                    this.minecraft.player.inventory.changeCurrentItem(f1);
                }
            }
        }
    }

    private void addPacksToScreen(long window, List<Path> paths) {
        if (this.minecraft.currentScreen != null) {
            this.minecraft.currentScreen.addPacks(paths);
        }
    }

    public void registerCallbacks(long handle) {
        if (this.minecraft.gameSettings.envPort != 0) {
            return;
        }
        InputMappings.setMouseCallbacks(handle, (handle_, xpos, ypos) -> this.minecraft.execute(() -> this.cursorPosCallback(handle_, xpos, ypos)), (handle_, button, action, mods) -> this.minecraft.execute(() -> this.mouseButtonCallback(handle_, button, action, mods)), (handle_, xoffset, yoffset) -> this.minecraft.execute(() -> this.scrollCallback(handle_, xoffset, yoffset)), (window, p_238227_3_, p_238227_4_) -> {
            Path[] apath = new Path[p_238227_3_];
            for (int i = 0; i < p_238227_3_; ++i) {
                apath[i] = Paths.get(GLFWDropCallback.getName(p_238227_4_, i), new String[0]);
            }
            this.minecraft.execute(() -> this.addPacksToScreen(window, Arrays.asList(apath)));
        });
    }

    public void executeIfHuman(Runnable runnable) {
        if (this.humanInput) {
            this.minecraft.execute(runnable);
        }
    }

    void cursorPosCallback(long handle, double xpos, double ypos) {
        if (handle == this.minecraft.getMainWindow().getHandle()) {
            if (this.ignoreFirstMove) {
                this.mouseX = xpos;
                this.mouseY = ypos;
                this.ignoreFirstMove = false;
            }
            if (this.humanInput) {
                this.cursorPosCallbackImpl(xpos, ypos);
            } else {
                this.dx = xpos - this.mouseX;
                this.dy = ypos - this.mouseY;
            }
        }
    }

    void cursorPosCallbackImpl(double xpos, double ypos) {
        Screen iguieventlistener = this.minecraft.currentScreen;
        if (iguieventlistener != null && this.minecraft.loadingGui == null) {
            double d0 = xpos * (double)this.minecraft.getMainWindow().getScaledWidth() / (double)this.minecraft.getMainWindow().getWidth();
            double d1 = ypos * (double)this.minecraft.getMainWindow().getScaledHeight() / (double)this.minecraft.getMainWindow().getHeight();
            Screen.wrapScreenError(() -> iguieventlistener.mouseMoved(d0, d1), "mouseMoved event handler", iguieventlistener.getClass().getCanonicalName());
            if (this.activeButton != -1 && this.eventTime > 0.0) {
                double d2 = (xpos - this.mouseX) * (double)this.minecraft.getMainWindow().getScaledWidth() / (double)this.minecraft.getMainWindow().getWidth();
                double d3 = (ypos - this.mouseY) * (double)this.minecraft.getMainWindow().getScaledHeight() / (double)this.minecraft.getMainWindow().getHeight();
                Screen.wrapScreenError(() -> iguieventlistener.mouseDragged(d0, d1, this.activeButton, d2, d3), "mouseDragged event handler", iguieventlistener.getClass().getCanonicalName());
            }
        }
        this.minecraft.getProfiler().startSection("mouse");
        if (this.isMouseGrabbed() && this.minecraft.isGameFocused()) {
            this.xVelocity += xpos - this.mouseX;
            this.yVelocity += ypos - this.mouseY;
        }
        this.updatePlayerLook();
        this.minecraft.getProfiler().endSection();
        this.mouseX = xpos;
        this.mouseY = ypos;
    }

    public void updatePlayerLook() {
        double pitch;
        double yaw;
        double time = NativeUtil.getTime();
        double dt = time - this.lastLookTime;
        this.lastLookTime = time;
        double d4 = this.minecraft.gameSettings.mouseSensitivity * (double)0.6f + (double)0.2f;
        double sensitivity = d4 * d4 * d4 * 8.0;
        if (this.minecraft.gameSettings.smoothCamera) {
            double d6 = this.xSmoother.smooth(this.xVelocity * sensitivity, dt * sensitivity);
            double d7 = this.ySmoother.smooth(this.yVelocity * sensitivity, dt * sensitivity);
            yaw = d6;
            pitch = d7;
        } else {
            this.xSmoother.reset();
            this.ySmoother.reset();
            yaw = this.xVelocity * sensitivity;
            pitch = this.yVelocity * sensitivity;
        }
        double xvel = this.xVelocity;
        this.xVelocity = 0.0;
        this.yVelocity = 0.0;
        int i = 1;
        if (this.minecraft.gameSettings.invertMouse) {
            i = -1;
        }
        this.minecraft.getTutorial().onMouseMove(yaw, pitch);
        if (this.minecraft.player != null) {
            this.minecraft.player.rotateTowards(yaw, pitch * (double)i);
        }
    }

    public boolean isLeftDown() {
        return this.leftDown;
    }

    public boolean isRightDown() {
        return this.rightDown;
    }

    public double getMouseX() {
        return this.mouseX;
    }

    public double getMouseY() {
        return this.mouseY;
    }

    public boolean isMouseGrabbed() {
        return this.mouseGrabbed;
    }

    public void grabMouse() {
        if (this.minecraft.isGameFocused() && !this.mouseGrabbed) {
            if (!Minecraft.IS_RUNNING_ON_MAC) {
                KeyBinding.updateKeyBindState();
            }
            this.mouseGrabbed = true;
            this.mouseX = this.minecraft.getMainWindow().getWidth() / 2;
            this.mouseY = this.minecraft.getMainWindow().getHeight() / 2;
            if (this.minecraft.gameSettings.envPort == 0) {
                InputMappings.setCursorPosAndMode(this.minecraft.getMainWindow().getHandle(), 212995, this.mouseX, this.mouseY);
            }
            this.minecraft.displayGuiScreen(null);
            this.minecraft.leftClickCounter = 10000;
            this.ignoreFirstMove = true;
        }
    }

    public void ungrabMouse() {
        if (this.mouseGrabbed) {
            this.mouseGrabbed = false;
            this.mouseX = this.minecraft.getMainWindow().getWidth() / 2;
            this.mouseY = this.minecraft.getMainWindow().getHeight() / 2;
            if (this.minecraft.gameSettings.envPort == 0) {
                InputMappings.setCursorPosAndMode(this.minecraft.getMainWindow().getHandle(), 212993, this.mouseX, this.mouseY);
            }
        }
    }

    public void ignoreFirstMove() {
        this.ignoreFirstMove = true;
    }

    public State getState() {
        double scaleFactor = this.getScaleFactor();
        State state = new State(this.mouseX, this.mouseY, this.dx / scaleFactor, this.dy / scaleFactor, this.accumDwheel, this.accumButtonsPressed, this.buttonsNewlyPressed);
        this.dx = 0.0;
        this.dy = 0.0;
        this.accumDwheel = 0.0;
        this.accumButtonsPressed.retainAll(this.buttonsPressed);
        this.buttonsNewlyPressed.clear();
        return state;
    }

    private boolean isGuiOpen() {
        return Minecraft.getInstance().currentScreen != null;
    }

    public double getScaleFactor() {
        double scaleFactor = 1.0;
        if (this.isGuiOpen()) {
            Minecraft mc = Minecraft.getInstance();
            double retinaFactor = mc.getFramebuffer().framebufferWidth / mc.getMainWindow().getWidth();
            scaleFactor = mc.getMainWindow().getGuiScaleFactor() / retinaFactor;
        }
        return scaleFactor;
    }

    public void clearState() {
        this.dx = 0.0;
        this.dy = 0.0;
        this.accumDwheel = 0.0;
        this.accumButtonsPressed.clear();
        this.buttonsPressed.clear();
        this.buttonsNewlyPressed.clear();
    }

    public boolean getHumanInput() {
        return this.humanInput;
    }

    public void setHumanInput(boolean humanInput) {
        this.humanInput = humanInput;
    }

    public static class State {
        public final double x;
        public final double y;
        public final double dx;
        public final double dy;
        public final double scaledX;
        public final double scaledY;
        public final double dwheel;
        public final Set<Integer> buttons;
        public final Set<Integer> newButtons;

        public State(double x, double y, double dx, double dy, double dwheel, Collection<Integer> buttons, Collection<Integer> newButtons) {
            MainWindow mw = Minecraft.getInstance().getMainWindow();
            MouseHelper mh = Minecraft.getInstance().mouseHelper;
            this.x = x;
            this.y = y;
            this.dx = dx;
            this.dy = dy;
            double scaleFactor = mh.getScaleFactor();
            this.scaledX = (x - (double)(mw.getWidth() / 2)) / scaleFactor;
            this.scaledY = (y - (double)(mw.getHeight() / 2)) / scaleFactor;
            this.dwheel = dwheel;
            this.buttons = new HashSet<Integer>();
            this.buttons.addAll(buttons);
            this.newButtons = new HashSet<Integer>();
            this.newButtons.addAll(newButtons);
        }
    }
}

