/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.material;

import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;

public final class Material {
    public static final Material AIR = Builder.access$000(new Builder(MaterialColor.AIR).doesNotBlockMovement()).notSolid().replaceable().build();
    public static final Material STRUCTURE_VOID = Builder.access$000(new Builder(MaterialColor.AIR).doesNotBlockMovement()).notSolid().replaceable().build();
    public static final Material PORTAL = Builder.access$000(new Builder(MaterialColor.AIR).doesNotBlockMovement()).notSolid().pushBlocks().build();
    public static final Material CARPET = Builder.access$000(new Builder(MaterialColor.WOOL).doesNotBlockMovement()).notSolid().flammable().build();
    public static final Material PLANTS = Builder.access$000(new Builder(MaterialColor.FOLIAGE).doesNotBlockMovement()).notSolid().pushDestroys().build();
    public static final Material OCEAN_PLANT = Builder.access$000(new Builder(MaterialColor.WATER).doesNotBlockMovement()).notSolid().pushDestroys().build();
    public static final Material TALL_PLANTS = Builder.access$000(new Builder(MaterialColor.FOLIAGE).doesNotBlockMovement()).notSolid().pushDestroys().replaceable().flammable().build();
    public static final Material NETHER_PLANTS = Builder.access$000(new Builder(MaterialColor.FOLIAGE).doesNotBlockMovement()).notSolid().pushDestroys().replaceable().build();
    public static final Material SEA_GRASS = Builder.access$000(new Builder(MaterialColor.WATER).doesNotBlockMovement()).notSolid().pushDestroys().replaceable().build();
    public static final Material WATER = Builder.access$000(new Builder(MaterialColor.WATER).doesNotBlockMovement()).notSolid().pushDestroys().replaceable().liquid().build();
    public static final Material BUBBLE_COLUMN = Builder.access$000(new Builder(MaterialColor.WATER).doesNotBlockMovement()).notSolid().pushDestroys().replaceable().liquid().build();
    public static final Material LAVA = Builder.access$000(new Builder(MaterialColor.TNT).doesNotBlockMovement()).notSolid().pushDestroys().replaceable().liquid().build();
    public static final Material SNOW = Builder.access$000(new Builder(MaterialColor.SNOW).doesNotBlockMovement()).notSolid().pushDestroys().replaceable().build();
    public static final Material FIRE = Builder.access$000(new Builder(MaterialColor.AIR).doesNotBlockMovement()).notSolid().pushDestroys().replaceable().build();
    public static final Material MISCELLANEOUS = Builder.access$000(new Builder(MaterialColor.AIR).doesNotBlockMovement()).notSolid().pushDestroys().build();
    public static final Material WEB = Builder.access$000(new Builder(MaterialColor.WOOL).doesNotBlockMovement()).pushDestroys().build();
    public static final Material REDSTONE_LIGHT = new Builder(MaterialColor.AIR).build();
    public static final Material CLAY = new Builder(MaterialColor.CLAY).build();
    public static final Material EARTH = new Builder(MaterialColor.DIRT).build();
    public static final Material ORGANIC = new Builder(MaterialColor.GRASS).build();
    public static final Material PACKED_ICE = new Builder(MaterialColor.ICE).build();
    public static final Material SAND = new Builder(MaterialColor.SAND).build();
    public static final Material SPONGE = new Builder(MaterialColor.YELLOW).build();
    public static final Material SHULKER = new Builder(MaterialColor.PURPLE).build();
    public static final Material WOOD = new Builder(MaterialColor.WOOD).flammable().build();
    public static final Material NETHER_WOOD = new Builder(MaterialColor.WOOD).build();
    public static final Material BAMBOO_SAPLING = new Builder(MaterialColor.WOOD).flammable().pushDestroys().doesNotBlockMovement().build();
    public static final Material BAMBOO = new Builder(MaterialColor.WOOD).flammable().pushDestroys().build();
    public static final Material WOOL = new Builder(MaterialColor.WOOL).flammable().build();
    public static final Material TNT = Builder.access$000(new Builder(MaterialColor.TNT).flammable()).build();
    public static final Material LEAVES = Builder.access$000(new Builder(MaterialColor.FOLIAGE).flammable()).pushDestroys().build();
    public static final Material GLASS = Builder.access$000(new Builder(MaterialColor.AIR)).build();
    public static final Material ICE = Builder.access$000(new Builder(MaterialColor.ICE)).build();
    public static final Material CACTUS = Builder.access$000(new Builder(MaterialColor.FOLIAGE)).pushDestroys().build();
    public static final Material ROCK = new Builder(MaterialColor.STONE).build();
    public static final Material IRON = new Builder(MaterialColor.IRON).build();
    public static final Material SNOW_BLOCK = new Builder(MaterialColor.SNOW).build();
    public static final Material ANVIL = new Builder(MaterialColor.IRON).pushBlocks().build();
    public static final Material BARRIER = new Builder(MaterialColor.AIR).pushBlocks().build();
    public static final Material PISTON = new Builder(MaterialColor.STONE).pushBlocks().build();
    public static final Material CORAL = new Builder(MaterialColor.FOLIAGE).pushDestroys().build();
    public static final Material GOURD = new Builder(MaterialColor.FOLIAGE).pushDestroys().build();
    public static final Material DRAGON_EGG = new Builder(MaterialColor.FOLIAGE).pushDestroys().build();
    public static final Material CAKE = new Builder(MaterialColor.AIR).pushDestroys().build();
    private final MaterialColor color;
    private final PushReaction pushReaction;
    private final boolean blocksMovement;
    private final boolean flammable;
    private final boolean isLiquid;
    private final boolean isOpaque;
    private final boolean replaceable;
    private final boolean isSolid;

    public Material(MaterialColor color, boolean isLiquid, boolean isSolid, boolean blocksMovement, boolean isOpaque, boolean flammable, boolean replaceable, PushReaction pushReaction) {
        this.color = color;
        this.isLiquid = isLiquid;
        this.isSolid = isSolid;
        this.blocksMovement = blocksMovement;
        this.isOpaque = isOpaque;
        this.flammable = flammable;
        this.replaceable = replaceable;
        this.pushReaction = pushReaction;
    }

    public boolean isLiquid() {
        return this.isLiquid;
    }

    public boolean isSolid() {
        return this.isSolid;
    }

    public boolean blocksMovement() {
        return this.blocksMovement;
    }

    public boolean isFlammable() {
        return this.flammable;
    }

    public boolean isReplaceable() {
        return this.replaceable;
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public PushReaction getPushReaction() {
        return this.pushReaction;
    }

    public MaterialColor getColor() {
        return this.color;
    }

    public static class Builder {
        private PushReaction pushReaction = PushReaction.NORMAL;
        private boolean blocksMovement = true;
        private boolean canBurn;
        private boolean isLiquid;
        private boolean isReplaceable;
        private boolean isSolid = true;
        private final MaterialColor color;
        private boolean isOpaque = true;

        public Builder(MaterialColor color) {
            this.color = color;
        }

        public Builder liquid() {
            this.isLiquid = true;
            return this;
        }

        public Builder notSolid() {
            this.isSolid = false;
            return this;
        }

        public Builder doesNotBlockMovement() {
            this.blocksMovement = false;
            return this;
        }

        private Builder notOpaque() {
            this.isOpaque = false;
            return this;
        }

        protected Builder flammable() {
            this.canBurn = true;
            return this;
        }

        public Builder replaceable() {
            this.isReplaceable = true;
            return this;
        }

        protected Builder pushDestroys() {
            this.pushReaction = PushReaction.DESTROY;
            return this;
        }

        protected Builder pushBlocks() {
            this.pushReaction = PushReaction.BLOCK;
            return this;
        }

        public Material build() {
            return new Material(this.color, this.isLiquid, this.isSolid, this.blocksMovement, this.isOpaque, this.canBurn, this.isReplaceable, this.pushReaction);
        }

        static /* synthetic */ Builder access$000(Builder x0) {
            return x0.notOpaque();
        }
    }
}

