/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.PistonBlockStructureHelper;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.PistonTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PistonBlock
extends DirectionalBlock {
    public static final BooleanProperty EXTENDED = BlockStateProperties.EXTENDED;
    protected static final VoxelShape PISTON_BASE_EAST_AABB = Block.makeCuboidShape(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape PISTON_BASE_WEST_AABB = Block.makeCuboidShape(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape PISTON_BASE_SOUTH_AABB = Block.makeCuboidShape(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape PISTON_BASE_NORTH_AABB = Block.makeCuboidShape(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape PISTON_BASE_UP_AABB = Block.makeCuboidShape(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape PISTON_BASE_DOWN_AABB = Block.makeCuboidShape(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean isSticky;

    public PistonBlock(boolean sticky, AbstractBlock.Properties properties) {
        super(properties);
        this.setDefaultState((BlockState)((BlockState)((BlockState)this.stateContainer.getBaseState()).with(FACING, Direction.NORTH)).with(EXTENDED, false));
        this.isSticky = sticky;
    }

    @Override
    public VoxelShape getShape(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.get(EXTENDED).booleanValue()) {
            switch (state.get(FACING)) {
                case DOWN: {
                    return PISTON_BASE_DOWN_AABB;
                }
                default: {
                    return PISTON_BASE_UP_AABB;
                }
                case NORTH: {
                    return PISTON_BASE_NORTH_AABB;
                }
                case SOUTH: {
                    return PISTON_BASE_SOUTH_AABB;
                }
                case WEST: {
                    return PISTON_BASE_WEST_AABB;
                }
                case EAST: 
            }
            return PISTON_BASE_EAST_AABB;
        }
        return VoxelShapes.fullCube();
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.isRemote) {
            this.checkForMove(worldIn, pos, state);
        }
    }

    @Override
    public void neighborChanged(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.isRemote) {
            this.checkForMove(worldIn, pos, state);
        }
    }

    @Override
    public void onBlockAdded(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.isIn(state.getBlock()) && !worldIn.isRemote && worldIn.getTileEntity(pos) == null) {
            this.checkForMove(worldIn, pos, state);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.getDefaultState().with(FACING, context.getNearestLookingDirection().getOpposite())).with(EXTENDED, false);
    }

    private void checkForMove(World worldIn, BlockPos pos, BlockState state) {
        Direction direction = state.get(FACING);
        boolean flag = this.shouldBeExtended(worldIn, pos, direction);
        if (flag && !state.get(EXTENDED).booleanValue()) {
            if (new PistonBlockStructureHelper(worldIn, pos, direction, true).canMove()) {
                worldIn.addBlockEvent(pos, this, 0, direction.getIndex());
            }
        } else if (!flag && state.get(EXTENDED).booleanValue()) {
            PistonTileEntity pistontileentity;
            TileEntity tileentity;
            BlockPos blockpos = pos.offset(direction, 2);
            BlockState blockstate = worldIn.getBlockState(blockpos);
            int i = 1;
            if (blockstate.isIn(Blocks.MOVING_PISTON) && blockstate.get(FACING) == direction && (tileentity = worldIn.getTileEntity(blockpos)) instanceof PistonTileEntity && (pistontileentity = (PistonTileEntity)tileentity).isExtending() && (pistontileentity.getProgress(0.0f) < 0.5f || worldIn.getGameTime() == pistontileentity.getLastTicked() || ((ServerWorld)worldIn).isInsideTick())) {
                i = 2;
            }
            worldIn.addBlockEvent(pos, this, i, direction.getIndex());
        }
    }

    private boolean shouldBeExtended(World worldIn, BlockPos pos, Direction facing) {
        for (Direction direction : Direction.values()) {
            if (direction == facing || !worldIn.isSidePowered(pos.offset(direction), direction)) continue;
            return true;
        }
        if (worldIn.isSidePowered(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.up();
        for (Direction direction1 : Direction.values()) {
            if (direction1 == Direction.DOWN || !worldIn.isSidePowered(blockpos.offset(direction1), direction1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean eventReceived(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        Direction direction = state.get(FACING);
        if (!worldIn.isRemote) {
            boolean flag = this.shouldBeExtended(worldIn, pos, direction);
            if (flag && (id == 1 || id == 2)) {
                worldIn.setBlockState(pos, (BlockState)state.with(EXTENDED, true), 2);
                return false;
            }
            if (!flag && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (!this.doMove(worldIn, pos, direction, true)) {
                return false;
            }
            worldIn.setBlockState(pos, (BlockState)state.with(EXTENDED, true), 67);
            worldIn.playSound(null, pos, SoundEvents.BLOCK_PISTON_EXTEND, SoundCategory.BLOCKS, 0.5f, worldIn.rand.nextFloat() * 0.25f + 0.6f);
        } else if (id == 1 || id == 2) {
            TileEntity tileentity1 = worldIn.getTileEntity(pos.offset(direction));
            if (tileentity1 instanceof PistonTileEntity) {
                ((PistonTileEntity)tileentity1).clearPistonTileEntity();
            }
            BlockState blockstate = (BlockState)((BlockState)Blocks.MOVING_PISTON.getDefaultState().with(MovingPistonBlock.FACING, direction)).with(MovingPistonBlock.TYPE, this.isSticky ? PistonType.STICKY : PistonType.DEFAULT);
            worldIn.setBlockState(pos, blockstate, 20);
            worldIn.setTileEntity(pos, MovingPistonBlock.createTilePiston((BlockState)this.getDefaultState().with(FACING, Direction.byIndex(param & 7)), direction, false, true));
            worldIn.func_230547_a_(pos, blockstate.getBlock());
            blockstate.updateNeighbours(worldIn, pos, 2);
            if (this.isSticky) {
                PistonTileEntity pistontileentity;
                TileEntity tileentity;
                BlockPos blockpos = pos.add(direction.getXOffset() * 2, direction.getYOffset() * 2, direction.getZOffset() * 2);
                BlockState blockstate1 = worldIn.getBlockState(blockpos);
                boolean flag1 = false;
                if (blockstate1.isIn(Blocks.MOVING_PISTON) && (tileentity = worldIn.getTileEntity(blockpos)) instanceof PistonTileEntity && (pistontileentity = (PistonTileEntity)tileentity).getFacing() == direction && pistontileentity.isExtending()) {
                    pistontileentity.clearPistonTileEntity();
                    flag1 = true;
                }
                if (!flag1) {
                    if (id != 1 || blockstate1.isAir() || !PistonBlock.canPush(blockstate1, worldIn, blockpos, direction.getOpposite(), false, direction) || blockstate1.getPushReaction() != PushReaction.NORMAL && !blockstate1.isIn(Blocks.PISTON) && !blockstate1.isIn(Blocks.STICKY_PISTON)) {
                        worldIn.removeBlock(pos.offset(direction), false);
                    } else {
                        this.doMove(worldIn, pos, direction, false);
                    }
                }
            } else {
                worldIn.removeBlock(pos.offset(direction), false);
            }
            worldIn.playSound(null, pos, SoundEvents.BLOCK_PISTON_CONTRACT, SoundCategory.BLOCKS, 0.5f, worldIn.rand.nextFloat() * 0.15f + 0.6f);
        }
        return true;
    }

    public static boolean canPush(BlockState blockStateIn, World worldIn, BlockPos pos, Direction facing, boolean destroyBlocks, Direction direction) {
        if (pos.getY() >= 0 && pos.getY() <= worldIn.getHeight() - 1 && worldIn.getWorldBorder().contains(pos)) {
            if (blockStateIn.isAir()) {
                return true;
            }
            if (!(blockStateIn.isIn(Blocks.OBSIDIAN) || blockStateIn.isIn(Blocks.CRYING_OBSIDIAN) || blockStateIn.isIn(Blocks.RESPAWN_ANCHOR))) {
                if (facing == Direction.DOWN && pos.getY() == 0) {
                    return false;
                }
                if (facing == Direction.UP && pos.getY() == worldIn.getHeight() - 1) {
                    return false;
                }
                if (!blockStateIn.isIn(Blocks.PISTON) && !blockStateIn.isIn(Blocks.STICKY_PISTON)) {
                    if (blockStateIn.getBlockHardness(worldIn, pos) == -1.0f) {
                        return false;
                    }
                    switch (blockStateIn.getPushReaction()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return destroyBlocks;
                        }
                        case PUSH_ONLY: {
                            return facing == direction;
                        }
                    }
                } else if (blockStateIn.get(EXTENDED).booleanValue()) {
                    return false;
                }
                return !blockStateIn.getBlock().isTileEntityProvider();
            }
            return false;
        }
        return false;
    }

    private boolean doMove(World worldIn, BlockPos pos, Direction directionIn, boolean extending) {
        PistonBlockStructureHelper pistonblockstructurehelper;
        BlockPos blockpos = pos.offset(directionIn);
        if (!extending && worldIn.getBlockState(blockpos).isIn(Blocks.PISTON_HEAD)) {
            worldIn.setBlockState(blockpos, Blocks.AIR.getDefaultState(), 20);
        }
        if (!(pistonblockstructurehelper = new PistonBlockStructureHelper(worldIn, pos, directionIn, extending)).canMove()) {
            return false;
        }
        HashMap<BlockPos, BlockState> map = Maps.newHashMap();
        List<BlockPos> list = pistonblockstructurehelper.getBlocksToMove();
        ArrayList<BlockState> list1 = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            BlockPos blockpos1 = list.get(i);
            BlockState blockstate = worldIn.getBlockState(blockpos1);
            list1.add(blockstate);
            map.put(blockpos1, blockstate);
        }
        List<BlockPos> list2 = pistonblockstructurehelper.getBlocksToDestroy();
        BlockState[] ablockstate = new BlockState[list.size() + list2.size()];
        Direction direction = extending ? directionIn : directionIn.getOpposite();
        int j = 0;
        for (int k = list2.size() - 1; k >= 0; --k) {
            BlockPos blockpos2 = list2.get(k);
            BlockState blockState = worldIn.getBlockState(blockpos2);
            TileEntity tileentity = blockState.getBlock().isTileEntityProvider() ? worldIn.getTileEntity(blockpos2) : null;
            PistonBlock.spawnDrops(blockState, worldIn, blockpos2, tileentity);
            worldIn.setBlockState(blockpos2, Blocks.AIR.getDefaultState(), 18);
            ablockstate[j++] = blockState;
        }
        for (int l = list.size() - 1; l >= 0; --l) {
            BlockPos blockpos3 = list.get(l);
            BlockState blockState = worldIn.getBlockState(blockpos3);
            blockpos3 = blockpos3.offset(direction);
            map.remove(blockpos3);
            worldIn.setBlockState(blockpos3, (BlockState)Blocks.MOVING_PISTON.getDefaultState().with(FACING, directionIn), 68);
            worldIn.setTileEntity(blockpos3, MovingPistonBlock.createTilePiston((BlockState)list1.get(l), directionIn, extending, false));
            ablockstate[j++] = blockState;
        }
        if (extending) {
            PistonType pistontype = this.isSticky ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState blockstate4 = (BlockState)((BlockState)Blocks.PISTON_HEAD.getDefaultState().with(PistonHeadBlock.FACING, directionIn)).with(PistonHeadBlock.TYPE, pistontype);
            BlockState blockState = (BlockState)((BlockState)Blocks.MOVING_PISTON.getDefaultState().with(MovingPistonBlock.FACING, directionIn)).with(MovingPistonBlock.TYPE, this.isSticky ? PistonType.STICKY : PistonType.DEFAULT);
            map.remove(blockpos);
            worldIn.setBlockState(blockpos, blockState, 68);
            worldIn.setTileEntity(blockpos, MovingPistonBlock.createTilePiston(blockstate4, directionIn, true, true));
        }
        BlockState blockstate3 = Blocks.AIR.getDefaultState();
        for (BlockPos blockPos : map.keySet()) {
            worldIn.setBlockState(blockPos, blockstate3, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockpos5 = (BlockPos)entry.getKey();
            BlockState blockstate2 = (BlockState)entry.getValue();
            blockstate2.updateDiagonalNeighbors(worldIn, blockpos5, 2);
            blockstate3.updateNeighbours(worldIn, blockpos5, 2);
            blockstate3.updateDiagonalNeighbors(worldIn, blockpos5, 2);
        }
        j = 0;
        for (int i1 = list2.size() - 1; i1 >= 0; --i1) {
            BlockState blockState = ablockstate[j++];
            BlockPos blockpos6 = list2.get(i1);
            blockState.updateDiagonalNeighbors(worldIn, blockpos6, 2);
            worldIn.notifyNeighborsOfStateChange(blockpos6, blockState.getBlock());
        }
        for (int j1 = list.size() - 1; j1 >= 0; --j1) {
            worldIn.notifyNeighborsOfStateChange(list.get(j1), ablockstate[j++].getBlock());
        }
        if (extending) {
            worldIn.notifyNeighborsOfStateChange(blockpos, Blocks.PISTON_HEAD);
        }
        return true;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.with(FACING, rot.rotate(state.get(FACING)));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.toRotation(state.get(FACING)));
    }

    @Override
    protected void fillStateContainer(StateContainer.Builder<Block, BlockState> builder) {
        builder.add(FACING, EXTENDED);
    }

    @Override
    public boolean isTransparent(BlockState state) {
        return state.get(EXTENDED);
    }

    @Override
    public boolean allowsMovement(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

