/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.gson.JsonObject;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.loot.LootContext;
import net.minecraft.util.ResourceLocation;

public class VillagerTradeTrigger
extends AbstractCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("villager_trade");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Instance deserializeTrigger(JsonObject json, EntityPredicate.AndPredicate entityPredicate, ConditionArrayParser conditionsParser) {
        EntityPredicate.AndPredicate entitypredicate$andpredicate = EntityPredicate.AndPredicate.deserializeJSONObject(json, "villager", conditionsParser);
        ItemPredicate itempredicate = ItemPredicate.deserialize(json.get("item"));
        return new Instance(entityPredicate, entitypredicate$andpredicate, itempredicate);
    }

    public void test(ServerPlayerEntity player, AbstractVillagerEntity villager, ItemStack stack) {
        LootContext lootcontext = EntityPredicate.getLootContext(player, villager);
        this.triggerListeners(player, instance -> instance.test(lootcontext, stack));
    }

    public static class Instance
    extends CriterionInstance {
        private final EntityPredicate.AndPredicate villager;
        private final ItemPredicate item;

        public Instance(EntityPredicate.AndPredicate player, EntityPredicate.AndPredicate villager, ItemPredicate stack) {
            super(ID, player);
            this.villager = villager;
            this.item = stack;
        }

        public static Instance any() {
            return new Instance(EntityPredicate.AndPredicate.ANY_AND, EntityPredicate.AndPredicate.ANY_AND, ItemPredicate.ANY);
        }

        public boolean test(LootContext context, ItemStack stack) {
            if (!this.villager.testContext(context)) {
                return false;
            }
            return this.item.test(stack);
        }

        @Override
        public JsonObject serialize(ConditionArraySerializer conditions) {
            JsonObject jsonobject = super.serialize(conditions);
            jsonobject.add("item", this.item.serialize());
            jsonobject.add("villager", this.villager.serializeConditions(conditions));
            return jsonobject;
        }
    }
}

