/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.ResourceLocation;

public class FishingRodHookedTrigger
extends AbstractCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("fishing_rod_hooked");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Instance deserializeTrigger(JsonObject json, EntityPredicate.AndPredicate entityPredicate, ConditionArrayParser conditionsParser) {
        ItemPredicate itempredicate = ItemPredicate.deserialize(json.get("rod"));
        EntityPredicate.AndPredicate entitypredicate$andpredicate = EntityPredicate.AndPredicate.deserializeJSONObject(json, "entity", conditionsParser);
        ItemPredicate itempredicate1 = ItemPredicate.deserialize(json.get("item"));
        return new Instance(entityPredicate, itempredicate, entitypredicate$andpredicate, itempredicate1);
    }

    public void trigger(ServerPlayerEntity player, ItemStack rod, FishingBobberEntity entity, Collection<ItemStack> items) {
        LootContext lootcontext = EntityPredicate.getLootContext(player, entity.func_234607_k_() != null ? entity.func_234607_k_() : entity);
        this.triggerListeners(player, instance -> instance.test(rod, lootcontext, items));
    }

    public static class Instance
    extends CriterionInstance {
        private final ItemPredicate rod;
        private final EntityPredicate.AndPredicate entity;
        private final ItemPredicate item;

        public Instance(EntityPredicate.AndPredicate player, ItemPredicate rod, EntityPredicate.AndPredicate entity, ItemPredicate item) {
            super(ID, player);
            this.rod = rod;
            this.entity = entity;
            this.item = item;
        }

        public static Instance create(ItemPredicate rod, EntityPredicate bobber, ItemPredicate item) {
            return new Instance(EntityPredicate.AndPredicate.ANY_AND, rod, EntityPredicate.AndPredicate.createAndFromEntityCondition(bobber), item);
        }

        public boolean test(ItemStack rod, LootContext context, Collection<ItemStack> items) {
            if (!this.rod.test(rod)) {
                return false;
            }
            if (!this.entity.testContext(context)) {
                return false;
            }
            if (this.item != ItemPredicate.ANY) {
                ItemEntity itementity;
                boolean flag = false;
                Entity entity = context.get(LootParameters.THIS_ENTITY);
                if (entity instanceof ItemEntity && this.item.test((itementity = (ItemEntity)entity).getItem())) {
                    flag = true;
                }
                for (ItemStack itemstack : items) {
                    if (!this.item.test(itemstack)) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public JsonObject serialize(ConditionArraySerializer conditions) {
            JsonObject jsonobject = super.serialize(conditions);
            jsonobject.add("rod", this.rod.serialize());
            jsonobject.add("entity", this.entity.serializeConditions(conditions));
            jsonobject.add("item", this.item.serialize());
            return jsonobject;
        }
    }
}

