/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.gson.JsonObject;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.MobEffectsPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;

public class EffectsChangedTrigger
extends AbstractCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("effects_changed");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Instance deserializeTrigger(JsonObject json, EntityPredicate.AndPredicate entityPredicate, ConditionArrayParser conditionsParser) {
        MobEffectsPredicate mobeffectspredicate = MobEffectsPredicate.deserialize(json.get("effects"));
        return new Instance(entityPredicate, mobeffectspredicate);
    }

    public void trigger(ServerPlayerEntity player) {
        this.triggerListeners(player, instance -> instance.test(player));
    }

    public static class Instance
    extends CriterionInstance {
        private final MobEffectsPredicate effects;

        public Instance(EntityPredicate.AndPredicate player, MobEffectsPredicate effects) {
            super(ID, player);
            this.effects = effects;
        }

        public static Instance forEffect(MobEffectsPredicate effects) {
            return new Instance(EntityPredicate.AndPredicate.ANY_AND, effects);
        }

        public boolean test(ServerPlayerEntity player) {
            return this.effects.test(player);
        }

        @Override
        public JsonObject serialize(ConditionArraySerializer conditions) {
            JsonObject jsonobject = super.serialize(conditions);
            jsonobject.add("effects", this.effects.serialize());
            return jsonobject;
        }
    }
}

