/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;

public class AdvancementTreeNode {
    private final Advancement advancement;
    private final AdvancementTreeNode parent;
    private final AdvancementTreeNode sibling;
    private final int index;
    private final List<AdvancementTreeNode> children = Lists.newArrayList();
    private AdvancementTreeNode ancestor;
    private AdvancementTreeNode thread;
    private int x;
    private float y;
    private float mod;
    private float change;
    private float shift;

    public AdvancementTreeNode(Advancement advancementIn, @Nullable AdvancementTreeNode parentIn, @Nullable AdvancementTreeNode siblingIn, int indexIn, int xIn) {
        if (advancementIn.getDisplay() == null) {
            throw new IllegalArgumentException("Can't position an invisible advancement!");
        }
        this.advancement = advancementIn;
        this.parent = parentIn;
        this.sibling = siblingIn;
        this.index = indexIn;
        this.ancestor = this;
        this.x = xIn;
        this.y = -1.0f;
        AdvancementTreeNode advancementtreenode = null;
        for (Advancement advancement : advancementIn.getChildren()) {
            advancementtreenode = this.buildSubTree(advancement, advancementtreenode);
        }
    }

    @Nullable
    private AdvancementTreeNode buildSubTree(Advancement advancementIn, @Nullable AdvancementTreeNode previous) {
        if (advancementIn.getDisplay() != null) {
            previous = new AdvancementTreeNode(advancementIn, this, previous, this.children.size() + 1, this.x + 1);
            this.children.add(previous);
        } else {
            for (Advancement advancement : advancementIn.getChildren()) {
                previous = this.buildSubTree(advancement, previous);
            }
        }
        return previous;
    }

    private void firstWalk() {
        if (this.children.isEmpty()) {
            this.y = this.sibling != null ? this.sibling.y + 1.0f : 0.0f;
        } else {
            AdvancementTreeNode advancementtreenode = null;
            for (AdvancementTreeNode advancementtreenode1 : this.children) {
                advancementtreenode1.firstWalk();
                advancementtreenode = advancementtreenode1.apportion(advancementtreenode == null ? advancementtreenode1 : advancementtreenode);
            }
            this.executeShifts();
            float f = (this.children.get((int)0).y + this.children.get((int)(this.children.size() - 1)).y) / 2.0f;
            if (this.sibling != null) {
                this.y = this.sibling.y + 1.0f;
                this.mod = this.y - f;
            } else {
                this.y = f;
            }
        }
    }

    private float secondWalk(float offsetY, int columnX, float subtreeTopY) {
        this.y += offsetY;
        this.x = columnX;
        if (this.y < subtreeTopY) {
            subtreeTopY = this.y;
        }
        for (AdvancementTreeNode advancementtreenode : this.children) {
            subtreeTopY = advancementtreenode.secondWalk(offsetY + this.mod, columnX + 1, subtreeTopY);
        }
        return subtreeTopY;
    }

    private void thirdWalk(float yIn) {
        this.y += yIn;
        for (AdvancementTreeNode advancementtreenode : this.children) {
            advancementtreenode.thirdWalk(yIn);
        }
    }

    private void executeShifts() {
        float f = 0.0f;
        float f1 = 0.0f;
        for (int i = this.children.size() - 1; i >= 0; --i) {
            AdvancementTreeNode advancementtreenode = this.children.get(i);
            advancementtreenode.y += f;
            advancementtreenode.mod += f;
            f += advancementtreenode.shift + (f1 += advancementtreenode.change);
        }
    }

    @Nullable
    private AdvancementTreeNode getFirstChild() {
        if (this.thread != null) {
            return this.thread;
        }
        return !this.children.isEmpty() ? this.children.get(0) : null;
    }

    @Nullable
    private AdvancementTreeNode getLastChild() {
        if (this.thread != null) {
            return this.thread;
        }
        return !this.children.isEmpty() ? this.children.get(this.children.size() - 1) : null;
    }

    private AdvancementTreeNode apportion(AdvancementTreeNode nodeIn) {
        if (this.sibling == null) {
            return nodeIn;
        }
        AdvancementTreeNode advancementtreenode = this;
        AdvancementTreeNode advancementtreenode1 = this;
        AdvancementTreeNode advancementtreenode2 = this.sibling;
        AdvancementTreeNode advancementtreenode3 = this.parent.children.get(0);
        float f = this.mod;
        float f1 = this.mod;
        float f2 = advancementtreenode2.mod;
        float f3 = advancementtreenode3.mod;
        while (advancementtreenode2.getLastChild() != null && advancementtreenode.getFirstChild() != null) {
            advancementtreenode2 = advancementtreenode2.getLastChild();
            advancementtreenode = advancementtreenode.getFirstChild();
            advancementtreenode3 = advancementtreenode3.getFirstChild();
            advancementtreenode1 = advancementtreenode1.getLastChild();
            advancementtreenode1.ancestor = this;
            float f4 = advancementtreenode2.y + f2 - (advancementtreenode.y + f) + 1.0f;
            if (f4 > 0.0f) {
                advancementtreenode2.getAncestor(this, nodeIn).moveSubtree(this, f4);
                f += f4;
                f1 += f4;
            }
            f2 += advancementtreenode2.mod;
            f += advancementtreenode.mod;
            f3 += advancementtreenode3.mod;
            f1 += advancementtreenode1.mod;
        }
        if (advancementtreenode2.getLastChild() != null && advancementtreenode1.getLastChild() == null) {
            advancementtreenode1.thread = advancementtreenode2.getLastChild();
            advancementtreenode1.mod += f2 - f1;
        } else {
            if (advancementtreenode.getFirstChild() != null && advancementtreenode3.getFirstChild() == null) {
                advancementtreenode3.thread = advancementtreenode.getFirstChild();
                advancementtreenode3.mod += f - f3;
            }
            nodeIn = this;
        }
        return nodeIn;
    }

    private void moveSubtree(AdvancementTreeNode nodeIn, float shift) {
        float f = nodeIn.index - this.index;
        if (f != 0.0f) {
            nodeIn.change -= shift / f;
            this.change += shift / f;
        }
        nodeIn.shift += shift;
        nodeIn.y += shift;
        nodeIn.mod += shift;
    }

    private AdvancementTreeNode getAncestor(AdvancementTreeNode self, AdvancementTreeNode other) {
        return this.ancestor != null && self.parent.children.contains(this.ancestor) ? this.ancestor : other;
    }

    private void updatePosition() {
        if (this.advancement.getDisplay() != null) {
            this.advancement.getDisplay().setPosition(this.x, this.y);
        }
        if (!this.children.isEmpty()) {
            for (AdvancementTreeNode advancementtreenode : this.children) {
                advancementtreenode.updatePosition();
            }
        }
    }

    public static void layout(Advancement root) {
        if (root.getDisplay() == null) {
            throw new IllegalArgumentException("Can't position children of an invisible root!");
        }
        AdvancementTreeNode advancementtreenode = new AdvancementTreeNode(root, null, null, 1, 0);
        advancementtreenode.firstWalk();
        float f = advancementtreenode.secondWalk(0.0f, 0, advancementtreenode.y);
        if (f < 0.0f) {
            advancementtreenode.thirdWalk(-f);
        }
        advancementtreenode.updatePosition();
    }
}

