/*
 * Decompiled with CFR 0.152.
 */
package com.minerl.multiagent.env;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.JavaResourcePack;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;

public class FakeMouseCursor {
    private static FakeMouseCursor instance = new FakeMouseCursor();

    private FakeMouseCursor() {
        System.out.println("*** creating fake mouse cursor ***");
    }

    public static FakeMouseCursor getInstance() {
        return instance;
    }

    public void render(MatrixStack matrixStack, Screen screen, int x, int y) {
        GameSettings gameSettings = Minecraft.getInstance().gameSettings;
        int size = gameSettings.fakeCursorSize;
        if (size == 0) {
            return;
        }
        GlStateManager.enableTexture();
        GlStateManager.disableLighting();
        GlStateManager.disableDepthTest();
        if (screen == null) {
            return;
        }
        GlStateManager.pushMatrix();
        FakeMouseCursor.bindTexture(size);
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc(516, 0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA.param, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.param);
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        screen.blit(matrixStack, x, y, 0, 0, size, size);
        GlStateManager.disableAlphaTest();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableLighting();
        GlStateManager.popMatrix();
    }

    private static void bindTexture(int size) {
        int rounded_size;
        if (size < 1 || size > 16) {
            throw new RuntimeException("Cursor size should be between 1 and 16 (requested " + size + ")");
        }
        for (rounded_size = 4; rounded_size < size; rounded_size <<= 1) {
        }
        String textureName = "cursors:mouse_cursor_white_" + rounded_size + "x" + rounded_size + ".png";
        TextureManager tm = Minecraft.getInstance().getTextureManager();
        IResourceManager rm = Minecraft.getInstance().getResourceManager();
        ResourceLocation texLocation = new ResourceLocation(textureName);
        if (tm.getTexture(texLocation) == null) {
            JavaResourcePack resourcePack = new JavaResourcePack();
            ((SimpleReloadableResourceManager)rm).addResourcePack(resourcePack);
            SimpleTexture texture = new SimpleTexture(texLocation);
            tm.loadTexture(texLocation, texture);
        }
        tm.bindTexture(texLocation);
        tm.getTexture(texLocation).setBlurMipmapDirect(false, false);
    }
}

