/*
 * Decompiled with CFR 0.152.
 */
package com.minerl.multiagent.env;

import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.microsoft.Malmo.Schemas.AgentStart;
import com.microsoft.Malmo.Schemas.InventoryObjectType;
import com.microsoft.Malmo.Schemas.MissionInit;
import com.microsoft.Malmo.Schemas.ObservationFromEquippedItem;
import com.microsoft.Malmo.Schemas.ObservationFromFullInventory;
import com.microsoft.Malmo.Schemas.ObservationFromFullStats;
import com.microsoft.Malmo.Schemas.Pos;
import com.microsoft.Malmo.Schemas.PosAndDirection;
import com.microsoft.Malmo.Schemas.ServerInitialConditions;
import com.microsoft.Malmo.Schemas.VideoProducer;
import com.microsoft.Malmo.Utils.JSONWorldDataHelper;
import com.minerl.multiagent.RandomHelper;
import com.minerl.multiagent.env.MissionSpec;
import com.minerl.multiagent.recorder.AzureUpload;
import com.minerl.multiagent.recorder.PlayRecorder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.KeyboardListener;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.ReplaySender;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.multiplayer.ServerAddress;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IResultableProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnvServer {
    private static Logger LOGGER = LogManager.getLogger();
    private static String hello = "<MalmoEnv";
    private static final int stepClientTagLength = "<StepClient_>".length();
    private static final int stepServerTagLength = "<StepServer_>".length();
    private boolean iwanttoquit = false;
    private boolean doneOnDeath = false;
    static final int BYTES_INT = 4;
    static final int BYTES_DOUBLE = 8;
    private static final int DEFAULT_SKIP_FIRST_FRAMES = 20;
    private int envTickCounter = -1;
    private MissionInit missionInit;
    private int port;
    private String version;

    public EnvServer(int port, String version) {
        this.port = port;
        this.version = version;
    }

    public void serve() {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(this.port);
            serverSocket.setPerformancePreferences(0, 2, 1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("***** Start MalmoEnvServer on port " + this.port);
        System.out.println("CLIENT enter state: DORMANT");
        System.out.println("SERVER enter state: DORMANT");
        while (!this.iwanttoquit) {
            try {
                final Socket socket = serverSocket.accept();
                socket.setTcpNoDelay(true);
                Thread thread = new Thread("EnvServerSocketHandler"){

                    @Override
                    public void run() {
                        block18: {
                            boolean running = false;
                            try {
                                String command;
                                EnvServer.this.checkHello(socket);
                                while (true) {
                                    DataInputStream din = new DataInputStream(socket.getInputStream());
                                    int hdr = 0;
                                    try {
                                        hdr = din.readInt();
                                    }
                                    catch (EOFException e) {
                                        LOGGER.debug("Incoming socket connection closed, likely by peer (without Exit message): " + e);
                                        socket.close();
                                        break block18;
                                    }
                                    byte[] data = new byte[hdr];
                                    din.readFully(data);
                                    command = new String(data, Charset.forName("UTF-8"));
                                    if (command.startsWith("<StepClient")) {
                                        EnvServer.this.stepClient(command, socket, din);
                                        continue;
                                    }
                                    if (command.startsWith("<StepServer")) {
                                        EnvServer.this.stepServer(command, socket);
                                        continue;
                                    }
                                    if (command.startsWith("<Peek")) {
                                        EnvServer.this.peek(command, socket, din);
                                        continue;
                                    }
                                    if (command.startsWith("<MissionInit")) {
                                        if (!EnvServer.this.initMission(din, command, socket)) continue;
                                        running = true;
                                        continue;
                                    }
                                    if (command.startsWith("<Quit")) {
                                        EnvServer.this.quit(command, socket);
                                        continue;
                                    }
                                    if (command.startsWith("<Exit")) {
                                        EnvServer.this.quit(command, socket);
                                        AzureUpload.finish();
                                        Minecraft.getInstance().shutdown();
                                        return;
                                    }
                                    if (command.startsWith("<Close")) continue;
                                    if (!command.startsWith("<Echo")) break;
                                    command = "<Echo>" + command + "</Echo>";
                                    data = command.getBytes(Charset.forName("UTF-8"));
                                    hdr = data.length;
                                    DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
                                    dout.writeInt(hdr);
                                    dout.write(data, 0, hdr);
                                    dout.flush();
                                }
                                if (command.startsWith("<Disconnect")) {
                                    socket.close();
                                    break block18;
                                }
                                throw new IOException("Unknown env service command: " + command);
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                                LOGGER.fatal("MalmoEnv socket error: " + ioe + " (can be on disconnect)");
                                try {
                                    if (running) {
                                        LOGGER.info("Want to quit on disconnect.");
                                        System.out.println("[LOGTOPY] Want to quit on disconnect.");
                                        EnvServer.this.setWantToQuit();
                                    }
                                    socket.close();
                                }
                                catch (IOException iOException) {}
                            }
                            catch (Exception e) {
                                LOGGER.error("Error while processing commands", (Throwable)e);
                                try {
                                    socket.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                };
                thread.start();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FATAL, "MalmoEnv service exits on " + ioe);
                LOGGER.error("IO Error while processing commands", (Throwable)ioe);
            }
            catch (Exception e) {
                LOGGER.error("Error while processing commands", (Throwable)e);
            }
        }
    }

    private void checkHello(Socket socket) throws IOException {
        DataInputStream din = new DataInputStream(socket.getInputStream());
        int hdr = din.readInt();
        if (hdr <= 0 || hdr > hello.length() + 8) {
            throw new IOException("Invalid MalmoEnv hello header length");
        }
        byte[] data = new byte[hdr];
        din.readFully(data);
        if (!new String(data).startsWith(hello + this.version)) {
            throw new IOException("MalmoEnv invalid protocol or version - expected " + hello + this.version);
        }
    }

    private void setWantToQuit() {
        this.iwanttoquit = true;
    }

    boolean initMission(DataInputStream din, String command, Socket socket) throws IOException, InterruptedException {
        int hdr = din.readInt();
        byte[] data = new byte[hdr];
        din.readFully(data);
        String id = new String(data, Charsets.UTF_8);
        LOGGER.info("Received Mission token " + id);
        LOGGER.info("Received mission init command  " + command);
        Minecraft mc = Minecraft.getInstance();
        this.missionInit = MissionSpec.decodeMissionInit(command);
        Long seed = null;
        String[] parts = id.split(":");
        if (parts.length >= 6) {
            try {
                seed = Long.parseLong(parts[5]);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Received invalid seed: " + parts[5]);
            }
        }
        if (seed == null) {
            seed = this.getSeed(this.missionInit);
        }
        Long final_seed = seed;
        this.setGameSetttings(this.missionInit);
        mc.getSession().setUsername(this.missionInit.getMission().getAgentSection().get(0).getName());
        this.setUsername(this.missionInit);
        mc.execute(() -> this.loadOrCreateWorld(this.missionInit, final_seed));
        while (!PlayRecorder.getInstance().isRecording()) {
            Thread.sleep(10L);
        }
        mc.execute(() -> this.setAgentInventory(mc.player, this.missionInit));
        mc.execute(() -> this.setAgentPosition(mc.player, this.missionInit));
        this.envTickCounter = PlayRecorder.getInstance().getTickCounter();
        int skipFrames = 20;
        for (int i = 0; i < skipFrames; ++i) {
            EnvServer.execActions("camera 0 0.0", 0);
            this.waitForNextObservation();
        }
        mc.execute(() -> {
            Pos startV = this.getAgentStart(this.missionInit).getVelocity();
            if (startV != null) {
                mc.player.setMotion(startV.getX(), startV.getY(), startV.getZ());
            }
        });
        DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
        dout.writeInt(4);
        dout.writeInt(1);
        dout.flush();
        return true;
    }

    private void setAgentInventory(ClientPlayerEntity player, MissionInit missionInit) {
        AgentStart.Inventory inventory = this.getAgentStart(missionInit).getInventory();
        if (inventory == null) {
            return;
        }
        inventory.getInventoryObject().forEach(e -> {
            String type = ((InventoryObjectType)e.getValue()).getType();
            int quantity = ((InventoryObjectType)e.getValue()).getQuantity();
            int slot = ((InventoryObjectType)e.getValue()).getSlot();
            Item item = Registry.ITEM.getOrDefault(new ResourceLocation(type));
            player.inventory.setInventorySlotContents(slot, new ItemStack(item, quantity));
            Minecraft.getInstance().getIntegratedServer().getPlayerList().getPlayers().forEach(p -> p.inventory.setInventorySlotContents(slot, new ItemStack(item, quantity)));
        });
    }

    private void setAgentPosition(ClientPlayerEntity player, MissionInit missionInit) {
        PosAndDirection startPos = this.getAgentStart(missionInit).getPlacement();
        if (startPos == null) {
            return;
        }
        player.setPosition(startPos.getX(), startPos.getY(), startPos.getZ());
        player.rotationYaw = startPos.getYaw();
        player.rotationPitch = startPos.getPitch();
    }

    private String getSaveFile(MissionInit missionInit) {
        return missionInit.getMission().getAgentSection().get(0).getAgentStart().getLoadWorldFile();
    }

    private void setUsername(MissionInit missionInit) {
        String username = this.getAgentStart(missionInit).getMultiplayerUsername();
        if (username != null) {
            Minecraft.getInstance().getSession().setUsername(username);
        }
    }

    private void setGameSetttings(MissionInit missionInit) {
        Minecraft mc = Minecraft.getInstance();
        GameSettings settings = mc.gameSettings;
        AgentStart agentStart = this.getAgentStart(missionInit);
        settings.gamma = agentStart.getGammaSetting().floatValue();
        settings.fov = agentStart.getFOVSetting().floatValue();
        settings.disableRecorder = agentStart.isEnableRecorder() == null || agentStart.isEnableRecorder() == false;
        settings.fakeCursorSize = agentStart.getFakeCursorSize();
        float guiScale = agentStart.getGuiScale().floatValue();
        settings.setSoundLevel(SoundCategory.MASTER, 0.0f);
        MainWindow window = mc.getMainWindow();
        this.getAgentHandlers().filter(h -> h instanceof VideoProducer).forEach(h -> {
            VideoProducer vp = (VideoProducer)h;
            System.out.println("Setting width, height to " + vp.getWidth() + ", " + vp.getHeight());
            double fbToWindowRatio = (double)window.getFramebufferWidth() / (double)window.getWidth();
            mc.execute(() -> {
                window.resize((int)((double)vp.getWidth() / fbToWindowRatio), (int)((double)vp.getHeight() / fbToWindowRatio));
                mc.updateWindowSize();
                window.setGuiScale(guiScale);
            });
        });
        System.out.println("Gamma: " + settings.gamma);
        System.out.println("FOV: " + settings.fov);
        System.out.println("GuiScale: " + guiScale);
    }

    private AgentStart getAgentStart(MissionInit missionInit) {
        return missionInit.getMission().getAgentSection().get(0).getAgentStart();
    }

    private void loadOrCreateWorld(MissionInit missionInit, Long seed) {
        String saveZipFile = this.getSaveFile(missionInit);
        if (saveZipFile == null) {
            String serverAddress = this.getServerAddress(missionInit);
            if (serverAddress == null) {
                this.createNewWorld(missionInit, seed);
            } else {
                this.connectToServer(serverAddress);
            }
        } else {
            ReplaySender.getInstance().loadWorldFromZip(saveZipFile);
        }
    }

    private String getServerAddress(MissionInit missionInit) {
        return EnvServer.getServerInit(missionInit).getRemoteServer();
    }

    private void connectToServer(String serverAddress) {
        Minecraft mc = Minecraft.getInstance();
        ServerData serverData = new ServerData("social", serverAddress, true);
        ServerAddress serveraddress = ServerAddress.fromString(serverData.serverIP);
        mc.displayGuiScreen(new ConnectingScreen(new MainMenuScreen(false), mc, serverData));
    }

    private void createNewWorld(MissionInit missionInit) {
        this.createNewWorld(missionInit, null);
    }

    private void createNewWorld(MissionInit missionInit, Long seed) {
        Minecraft mc = Minecraft.getInstance();
        boolean bonusChest = this.isBonusChest(missionInit);
        boolean generateFeatures = this.isGenerateFeatures(missionInit);
        boolean spawnInVillage = this.isSpawnInVillage(missionInit);
        this.doneOnDeath = this.isDoneOnDeath(missionInit);
        if (this.doneOnDeath) {
            mc.setHasPlayerRespawned(false);
        }
        if (seed == null) {
            seed = new Random().nextLong();
            System.out.println("Seed not provided, generating random one: " + String.valueOf(seed));
        }
        String worldName = "mcpworld" + RandomHelper.getRandomHexString();
        String spawnBiome = this.getAgentStart(missionInit).getPreferredSpawnBiome();
        if (spawnBiome != null) {
            this.checkValidBiome(spawnBiome);
            MinecraftServer.setSpawnBiomePredicate(b -> b.getCategory().getName().equals(spawnBiome));
        }
        if (spawnInVillage) {
            MinecraftServer.setSpawnInVillage(true);
        }
        WorldSettings worldSettings = new WorldSettings(worldName, GameType.SURVIVAL, false, Difficulty.HARD, true, new GameRules(), DatapackCodec.VANILLA_CODEC);
        DimensionGeneratorSettings dms = DimensionGeneratorSettings.fromDynamicRegistries(DynamicRegistries.getImpl(), seed, generateFeatures, bonusChest);
        mc.createWorld(worldName, worldSettings, DynamicRegistries.getImpl(), dms);
    }

    private void checkValidBiome(String spawnBiome) {
        Set biomeCategories = DynamicRegistries.getImpl().getRegistry(Registry.BIOME_KEY).getEntries().stream().map(e -> ((Biome)e.getValue()).getCategory().getName()).collect(Collectors.toSet());
        if (!biomeCategories.contains(spawnBiome)) {
            LOGGER.error("Bad starting biome " + spawnBiome);
            LOGGER.error("Biome should be one of the following: ");
            for (String b : biomeCategories) {
                LOGGER.error("- " + b);
            }
            throw new RuntimeException("Bad starting biome " + spawnBiome);
        }
    }

    private Long getSeed(MissionInit missionInit) {
        return this.getAgentStart(missionInit).getWorldSeed();
    }

    private boolean isBonusChest(MissionInit missionInit) {
        Boolean bonusChest = this.getAgentStart(missionInit).isBonusChest();
        return bonusChest != null && bonusChest != false;
    }

    private boolean isGenerateFeatures(MissionInit missionInit) {
        Boolean genFeatures = this.getAgentStart(missionInit).isGenerateFeatures();
        return genFeatures == null || genFeatures != false;
    }

    private boolean isSpawnInVillage(MissionInit missionInit) {
        Boolean spawnInVillage = this.getAgentStart(missionInit).isSpawnInVillage();
        return spawnInVillage != null && spawnInVillage != false;
    }

    private boolean isDoneOnDeath(MissionInit missionInit) {
        Boolean doneOnDeath = this.getAgentStart(missionInit).isDoneOnDeath();
        return doneOnDeath != null && doneOnDeath != false;
    }

    void peek(String command, Socket socket, DataInputStream din) throws IOException, ExecutionException, InterruptedException {
        Minecraft mc = Minecraft.getInstance();
        DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
        byte[] obs = this.getPOVObservation();
        boolean done = false;
        String info = this.getInfo("");
        dout.writeInt(obs.length);
        dout.write(obs);
        byte[] infoBytes = info.getBytes(Charset.forName("UTF-8"));
        dout.writeInt(infoBytes.length);
        dout.write(infoBytes);
        dout.writeInt(1);
        dout.writeByte(done ? 1 : 0);
        dout.flush();
    }

    private byte[] getPOVObservation() {
        return PlayRecorder.getInstance().getLastImageBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNextObservation() {
        PlayRecorder pr = PlayRecorder.getInstance();
        try {
            PlayRecorder playRecorder = pr;
            synchronized (playRecorder) {
                while (this.envTickCounter == pr.getTickCounter()) {
                    pr.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.envTickCounter = PlayRecorder.getInstance().getTickCounter();
    }

    private void stepClient(String command, Socket socket, DataInputStream din) throws IOException {
        Minecraft mc = Minecraft.getInstance();
        String actions = command.substring(stepClientTagLength, command.length() - (stepClientTagLength + 2));
        int options = Character.getNumericValue(command.charAt(stepServerTagLength - 2));
        boolean withInfo = options == 0 || options == 2;
        this.envTickCounter = PlayRecorder.getInstance().getTickCounter();
        EnvServer.execActions(actions, options);
        this.waitForNextObservation();
        byte[] obs = this.getPOVObservation();
        boolean done = mc.player == null || !mc.player.isAlive() || this.doneOnDeath && mc.isHasPlayerRespawned();
        boolean sent = true;
        DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
        dout.writeInt(obs.length);
        dout.write(obs);
        dout.writeInt(10);
        dout.writeDouble(0.0);
        dout.writeByte(done ? 1 : 0);
        dout.writeByte(sent ? 1 : 0);
        if (withInfo) {
            String info = this.getInfo(actions);
            byte[] infoBytes = info.getBytes(Charsets.UTF_8);
            dout.writeInt(infoBytes.length);
            dout.write(infoBytes);
        }
        dout.flush();
    }

    private Stream<Object> getAgentHandlers() {
        return this.missionInit.getMission().getAgentSection().get(0).getAgentHandlers().getAgentMissionHandlers().stream();
    }

    private static ServerInitialConditions getServerInit(MissionInit missionInit) {
        return missionInit.getMission().getServerSection().getServerInitialConditions();
    }

    private String getInfo(String actions) {
        String[] splitAction;
        Minecraft mc = Minecraft.getInstance();
        JsonObject infoJson = new JsonObject();
        List<Object> handlers = this.missionInit.getMission().getAgentSection().get(0).getAgentHandlers().getAgentMissionHandlers();
        if (mc.player != null) {
            this.getAgentHandlers().filter(h -> h instanceof ObservationFromFullInventory).limit(1L).forEach(h -> infoJson.add("inventory", EnvServer.getInventoryJson()));
            this.getAgentHandlers().filter(h -> h instanceof ObservationFromFullStats).limit(1L).forEach(h -> JSONWorldDataHelper.buildAllStats(infoJson, mc.player));
            this.getAgentHandlers().filter(h -> h instanceof ObservationFromEquippedItem).limit(1L).forEach(h -> infoJson.add("equipped_items", EnvServer.getEquippedItemJson()));
        }
        JsonObject pos = new JsonObject();
        pos.addProperty("pitch", Float.valueOf(mc.player.getRotationPitch()));
        pos.addProperty("yaw", Float.valueOf(mc.player.getRotationYaw()));
        pos.addProperty("x", mc.player.getPlayerX());
        pos.addProperty("y", mc.player.getPlayerY());
        pos.addProperty("z", mc.player.getPlayerZ());
        infoJson.addProperty("player_pos", pos.toString());
        if (mc.player != null) {
            for (String action : actions.split("\n")) {
                splitAction = action.trim().split(" ");
                if (!splitAction[0].equals("voxels") || splitAction.length <= 1) continue;
                String voxelMessage = action.trim().substring(splitAction[0].length()).trim();
                BlockPos playerPos = new BlockPos(mc.player.getPosX(), mc.player.getPosY(), mc.player.getPosZ());
                String[] bbox = voxelMessage.split(",");
                int xlow = Integer.parseInt(bbox[0]);
                int xhigh = Integer.parseInt(bbox[1]);
                int ylow = Integer.parseInt(bbox[2]);
                int yhigh = Integer.parseInt(bbox[3]);
                int zlow = Integer.parseInt(bbox[4]);
                int zhigh = Integer.parseInt(bbox[5]);
                JsonArray result = new JsonArray();
                for (int x = xlow; x < xhigh; ++x) {
                    for (int y = ylow; y < yhigh; ++y) {
                        for (int z = zlow; z < zhigh; ++z) {
                            BlockPos blockPos = playerPos.add(x, y, z);
                            if (mc.world.getBlockState(blockPos).isAir()) continue;
                            JsonObject block = new JsonObject();
                            BlockState blockState = mc.world.getBlockState(blockPos);
                            ResourceLocation resourcelocation = Registry.BLOCK.getKey(blockState.getBlock());
                            String blocktype = resourcelocation.getFullName();
                            block.addProperty("x", x);
                            block.addProperty("y", y);
                            block.addProperty("z", z);
                            block.addProperty("type", blocktype);
                            result.add(block);
                        }
                    }
                }
                infoJson.add("voxels", result);
            }
        }
        if (mc.player != null) {
            for (String action : actions.split("\n")) {
                splitAction = action.trim().split(" ");
                if (!splitAction[0].equals("mobs") || splitAction.length <= 1) continue;
                String mobMessage = action.trim().substring(splitAction[0].length()).trim();
                String[] bbox = mobMessage.split(",");
                double xlow = mc.player.getPosX() + (double)Integer.parseInt(bbox[0]);
                double xhigh = mc.player.getPosX() + (double)Integer.parseInt(bbox[1]);
                double ylow = mc.player.getPosY() + (double)Integer.parseInt(bbox[2]);
                double yhigh = mc.player.getPosY() + (double)Integer.parseInt(bbox[3]);
                double zlow = mc.player.getPosZ() + (double)Integer.parseInt(bbox[4]);
                double zhigh = mc.player.getPosZ() + (double)Integer.parseInt(bbox[5]);
                AxisAlignedBB aabb = new AxisAlignedBB(xlow, ylow, zlow, xhigh, yhigh, zhigh);
                JsonArray result = new JsonArray();
                for (AnimalEntity entity : mc.world.getEntitiesWithinAABB(AnimalEntity.class, aabb)) {
                    JsonObject ent = new JsonObject();
                    ent.addProperty("x", entity.getPosX() - mc.player.getPosX());
                    ent.addProperty("y", entity.getPosY() - mc.player.getPosY());
                    ent.addProperty("z", entity.getPosZ() - mc.player.getPosZ());
                    ent.addProperty("name", entity.getClass().getSimpleName());
                    result.add(ent);
                }
                infoJson.add("mobs", result);
            }
        }
        infoJson.addProperty("food_level", mc.player.getFoodStats().getFoodLevel());
        infoJson.addProperty("health", Float.valueOf(mc.player.getHealth()));
        infoJson.addProperty("isGuiOpen", mc.currentScreen != null);
        return infoJson.toString();
    }

    public static JsonArray getInventoryJson() {
        JsonArray result = new JsonArray();
        PlayerInventory inventory = Minecraft.getInstance().player.inventory;
        List<ItemStack> items = inventory.mainInventory.getList();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack item = items.get(i);
            JsonObject stack = new JsonObject();
            stack.addProperty("slot_id", i);
            if (item.getCount() == 0) {
                stack.addProperty("type", "none");
                stack.addProperty("quantity", 0);
            } else {
                stack.addProperty("type", item.getItem().toString());
                stack.addProperty("quantity", item.getCount());
            }
            result.add(stack);
        }
        return result;
    }

    public static JsonObject getEquippedItemJson() {
        JsonObject result = new JsonObject();
        ClientPlayerEntity player = Minecraft.getInstance().player;
        assert (player != null);
        result.addProperty("mainhand", EnvServer.getEquipmentJsonObjectFromPlayer(player, EquipmentSlotType.MAINHAND));
        result.addProperty("offhand", EnvServer.getEquipmentJsonObjectFromPlayer(player, EquipmentSlotType.OFFHAND));
        result.addProperty("head", EnvServer.getEquipmentJsonObjectFromPlayer(player, EquipmentSlotType.HEAD));
        result.addProperty("chest", EnvServer.getEquipmentJsonObjectFromPlayer(player, EquipmentSlotType.CHEST));
        result.addProperty("legs", EnvServer.getEquipmentJsonObjectFromPlayer(player, EquipmentSlotType.LEGS));
        result.addProperty("feet", EnvServer.getEquipmentJsonObjectFromPlayer(player, EquipmentSlotType.FEET));
        return result;
    }

    private static String getEquipmentJsonObjectFromPlayer(PlayerEntity player, EquipmentSlotType type) {
        JsonObject result = new JsonObject();
        ItemStack item = player.getItemStackFromSlot(type);
        result.addProperty("type", item.getItem().toString());
        result.addProperty("maxDamage", item.getMaxDamage());
        result.addProperty("damage", item.getDamage());
        return result.toString();
    }

    public static void execActions(String actions, int options) {
        EnvServer.doChatActions(actions);
        KeyboardListener.State keysState = EnvServer.constructKeyboardState(actions);
        MouseHelper.State mouseState = EnvServer.constructMouseState(actions);
        PlayRecorder.getInstance().setMouseKeyboardState(mouseState, keysState);
        ReplaySender.getInstance().addAction(mouseState, keysState);
    }

    public static void doChatActions(String actions) {
        for (String action : actions.split("\n")) {
            String[] splitAction = action.trim().split(" ");
            if (!splitAction[0].equals("chat") || splitAction.length <= 1) continue;
            String chatMessage = action.trim().substring(splitAction[0].length()).trim();
            Minecraft.getInstance().player.sendChatMessage(chatMessage);
        }
    }

    private static KeyboardListener.State constructKeyboardState(String actions) {
        ArrayList<String> keysPressed = new ArrayList<String>();
        for (String action : actions.split("\n")) {
            String key;
            String[] splitAction = action.trim().split(" ");
            if (splitAction[0].equals("camera") || splitAction[0].equals("dwheel") || splitAction[0].equals("chat") || splitAction[0].equals("voxels") || splitAction[0].equals("mobs") || splitAction[0].equals("equip") || splitAction.length <= 1 || Integer.parseInt(splitAction[1]) != 1 || (key = EnvServer.actionToKey(splitAction[0])) == null) continue;
            keysPressed.add(key);
        }
        return new KeyboardListener.State(keysPressed, Collections.emptyList(), "");
    }

    private static MouseHelper.State constructMouseState(String actions) {
        ArrayList<Integer> buttonsPressed = new ArrayList<Integer>();
        double dx = 0.0;
        double dy = 0.0;
        double dwheel = 0.0;
        double sensitivity = 6.666666666666667;
        for (String action : actions.split("\n")) {
            Integer key;
            String[] splitAction = action.trim().split(" ");
            if (splitAction[0].equals("camera")) {
                dx = Double.parseDouble(splitAction[2]) * sensitivity;
                dy = Double.parseDouble(splitAction[1]) * sensitivity;
                continue;
            }
            if (splitAction[0].equals("dwheel")) {
                dwheel = Double.parseDouble(splitAction[1]);
                continue;
            }
            if (splitAction[0].equals("chat") || splitAction[0].equals("voxels") || splitAction[0].equals("mobs") || splitAction.length <= 1 || Integer.parseInt(splitAction[1]) != 1 || (key = EnvServer.actionToMouseButton(splitAction[0])) == null) continue;
            buttonsPressed.add(key);
        }
        return new MouseHelper.State(0.0, 0.0, dx, dy, dwheel, buttonsPressed, Collections.emptyList());
    }

    private static Integer actionToMouseButton(String action) {
        if (action.equals("attack")) {
            return 0;
        }
        if (action.equals("use")) {
            return 1;
        }
        if (action.equals("pickItem")) {
            return 2;
        }
        return null;
    }

    private static String actionToKey(String action) {
        if (action.equals("forward")) {
            return "key.keyboard.w";
        }
        if (action.equals("back")) {
            return "key.keyboard.s";
        }
        if (action.equals("left")) {
            return "key.keyboard.a";
        }
        if (action.equals("right")) {
            return "key.keyboard.d";
        }
        if (action.equals("jump")) {
            return "key.keyboard.space";
        }
        if (action.equals("sprint")) {
            return "key.keyboard.left.control";
        }
        if (action.equals("sneak")) {
            return "key.keyboard.left.shift";
        }
        if (action.startsWith("hotbar")) {
            return "key.keyboard." + action.split("\\.")[1];
        }
        if (action.equals("inventory")) {
            return "key.keyboard.e";
        }
        if (action.equals("drop")) {
            return "key.keyboard.q";
        }
        if (action.equals("swapHands")) {
            return "key.keyboard.f";
        }
        if (action.equals("ESC")) {
            return "key.keyboard.escape";
        }
        return null;
    }

    void stepServer(String command, Socket socket) {
    }

    private void quit(String command, Socket socket) throws IOException, InterruptedException {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getProfiler() instanceof IResultableProfiler) {
            File profileDump = new File("profile-results-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".txt");
            ((IResultableProfiler)mc.getProfiler()).getResults().writeToFile(profileDump.getAbsoluteFile());
        }
        PlayRecorder.getInstance().finishAndResetEpisode();
        ReplaySender.getInstance().stop();
        while (!(mc.currentScreen instanceof MainMenuScreen)) {
            Thread.sleep(10L);
        }
        DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
        dout.writeInt(4);
        dout.writeInt(1);
        dout.flush();
    }
}

