/*
 * Decompiled with CFR 0.152.
 */
package com.minerl.multiagent;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.Hex;

public class RandomHelper {
    private static Random seedsRand = new Random(0L);
    private static Map<String, Random> rands = new HashMap<String, Random>();
    private static int DEFAULT_LENGTH = 6;

    public static Random getRandom() {
        return RandomHelper.getRandom("default");
    }

    public static Random getRandom(String key) {
        if (!rands.containsKey(key)) {
            rands.put(key, new Random(seedsRand.nextLong()));
        }
        return rands.get(key);
    }

    public static Random getRandom(String key, long defaultSeed) {
        if (!rands.containsKey(key)) {
            rands.put(key, new Random(defaultSeed));
        }
        return rands.get(key);
    }

    public static synchronized String getRandomHexString() {
        return RandomHelper.getRandomHexString(DEFAULT_LENGTH);
    }

    public static synchronized String getRandomHexString(int nbytes) {
        byte[] buf = new byte[nbytes];
        RandomHelper.getRandom().nextBytes(buf);
        return new String(Hex.encodeHexString(buf));
    }

    public static synchronized double randomDouble() {
        return RandomHelper.getRandom().nextDouble();
    }

    public static long getSeed(Random rand) {
        try {
            Field seedField = Random.class.getDeclaredField("seed");
            seedField.setAccessible(true);
            return ((AtomicLong)seedField.get(rand)).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static double nextDouble() {
        return RandomHelper.nextDouble("default");
    }

    public static double nextDouble(String key) {
        Random rand = RandomHelper.getRandom(key);
        return RandomHelper.getRandom(key).nextDouble();
    }

    public static float nextFloat() {
        return RandomHelper.nextFloat("default");
    }

    public static float nextFloat(String key) {
        Random rand = RandomHelper.getRandom(key);
        return RandomHelper.getRandom(key).nextFloat();
    }

    public static long nextLong() {
        return RandomHelper.nextLong("default");
    }

    public static long nextLong(String key) {
        Random rand = RandomHelper.getRandom(key);
        return RandomHelper.getRandom(key).nextLong();
    }
}

